/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.ArrayList;
import java.util.List;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.spi.RadixConstants;
import org.apfloat.spi.Util;

class RadixConversionHelper {
    private RadixConversionHelper() {
    }

    public static Apfloat toRadix(Apfloat x2, int toRadix) throws ApfloatRuntimeException {
        if (x2.radix() == toRadix) {
            return x2;
        }
        if (x2.signum() == 0) {
            return new Apfloat(0L, (long)toRadix);
        }
        int fromRadix = x2.radix();
        long size2 = x2.size();
        long scale = x2.scale();
        long precision = RadixConversionHelper.getPrecision(x2.precision(), fromRadix, toRadix);
        RadixPowerList radixPowerList = new RadixPowerList(fromRadix, toRadix, precision);
        return RadixConversionHelper.toRadixIntegerPart(x2, toRadix, size2, scale, radixPowerList).add(RadixConversionHelper.toRadixFractionalPart(x2, toRadix, size2, scale, radixPowerList)).precision(precision);
    }

    private static Apfloat toRadixIntegerPart(Apfloat x2, int toRadix, long size2, long scale, RadixPowerList radixPowerList) throws ApfloatRuntimeException {
        if (scale <= 0L) {
            return Apfloat.ZERO;
        }
        if (scale > size2) {
            long shift = scale - size2;
            x2 = ApfloatMath.scale(x2, -shift);
            x2 = RadixConversionHelper.toRadixNormalizedPart(x2, toRadix, size2, radixPowerList);
            return x2.multiply(radixPowerList.pow(shift));
        }
        x2 = x2.truncate();
        return RadixConversionHelper.toRadixNormalizedPart(x2, toRadix, x2.scale(), radixPowerList);
    }

    private static Apfloat toRadixFractionalPart(Apfloat x2, int toRadix, long size2, long scale, RadixPowerList radixPowerList) throws ApfloatRuntimeException {
        if (size2 > scale) {
            if (scale > 0L) {
                x2 = x2.subtract(x2.truncate());
                size2 -= scale;
                scale = 0L;
            }
            long precision = RadixConversionHelper.getPrecision(x2.precision(), x2.radix(), toRadix);
            long shift = size2 - scale;
            x2 = ApfloatMath.scale(x2, shift);
            x2 = RadixConversionHelper.toRadixNormalizedPart(x2, toRadix, size2, radixPowerList);
            return x2.precision(precision).divide(radixPowerList.pow(shift));
        }
        return Apfloat.ZERO;
    }

    private static Apfloat toRadixNormalizedPart(Apfloat x2, int toRadix, long size2, RadixPowerList radixPowerList) throws ApfloatRuntimeException {
        long maxPow2 = Util.round2down(size2);
        return RadixConversionHelper.split(x2, toRadix, size2, maxPow2, radixPowerList);
    }

    private static Apfloat split(Apfloat x2, int toRadix, long size2, long split2, RadixPowerList radixPowerList) throws ApfloatRuntimeException {
        if (size2 <= 0L) {
            return Apfloat.ZERO;
        }
        if (size2 <= (long)RadixConstants.LONG_DIGITS[x2.radix()]) {
            return new Apfloat(x2.longValue(), Long.MAX_VALUE, toRadix);
        }
        Apint top = ApfloatMath.scale(x2, -split2).truncate();
        Apfloat bottom = x2.subtract(ApfloatMath.scale(top, split2));
        return RadixConversionHelper.split(top, toRadix, size2 - split2, split2 >> 1, radixPowerList).multiply(radixPowerList.pow(split2)).add(RadixConversionHelper.split(bottom, toRadix, split2, split2 >> 1, radixPowerList));
    }

    private static long getPrecision(long precision, int fromRadix, int toRadix) throws ApfloatRuntimeException {
        long newPrecision = (long)((double)precision * Math.log(fromRadix) / Math.log(toRadix));
        if (fromRadix < toRadix) {
            newPrecision = Math.max(1L, newPrecision);
        }
        return Util.ifFinite(precision, newPrecision);
    }

    private static class RadixPowerList {
        private List<Apfloat> list = new ArrayList<Apfloat>();

        public RadixPowerList(int fromRadix, int toRadix, long precision) throws ApfloatRuntimeException {
            this.list.add(new Apfloat(fromRadix, ApfloatHelper.extendPrecision(precision), toRadix));
        }

        public Apfloat pow(long n) throws ApfloatRuntimeException {
            if (n == 0L) {
                return Apfloat.ONE;
            }
            int p = 0;
            while ((n & 1L) == 0L) {
                ++p;
                n >>>= 1;
            }
            Apfloat r = this.get(p);
            while ((n >>>= 1) > 0L) {
                Apfloat x2 = this.get(++p);
                if ((n & 1L) == 0L) continue;
                r = r.multiply(x2);
            }
            return r;
        }

        private Apfloat get(int index) throws ApfloatRuntimeException {
            Apfloat x2;
            if (this.list.size() > index) {
                x2 = this.list.get(index);
            } else {
                x2 = this.get(index - 1);
                x2 = x2.multiply(x2);
                this.list.add(x2);
            }
            return x2;
        }
    }
}

