/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.lang.expression;

import org.snpsift.lang.expression.SimpleIterator;

public class FieldIterator {
    private static final FieldIterator fieldIterator = new FieldIterator();
    int type = 0;
    SimpleIterator var = new SimpleIterator();
    SimpleIterator gentype = new SimpleIterator();
    SimpleIterator effect = new SimpleIterator();
    SimpleIterator gentypeVar = new SimpleIterator();
    SimpleIterator lof = new SimpleIterator();
    SimpleIterator nmd = new SimpleIterator();

    public static FieldIterator get() {
        return fieldIterator;
    }

    public int get(IteratorType iterType) {
        switch (iterType) {
            case VAR: {
                return this.var.current;
            }
            case GENOTYPE: {
                return this.gentype.current;
            }
            case GENOTYPE_VAR: {
                return this.gentypeVar.current;
            }
            case EFFECT: {
                return this.effect.current;
            }
            case LOF: {
                return this.lof.current;
            }
            case NMD: {
                return this.nmd.current;
            }
        }
        throw new RuntimeException("Unknown iterator type '" + (Object)((Object)iterType) + "'");
    }

    public int getType() {
        return this.type;
    }

    public boolean hasNext() {
        return this.var.hasNext() || this.effect.hasNext() || this.gentype.hasNext() || this.gentypeVar.hasNext();
    }

    public void next() {
        if (this.gentypeVar.hasNext()) {
            this.gentypeVar.next();
            return;
        }
        if (this.gentype.hasNext()) {
            this.gentypeVar.reset();
            this.gentype.next();
            return;
        }
        if (this.nmd.hasNext()) {
            this.gentypeVar.reset();
            this.gentype.reset();
            this.nmd.next();
            return;
        }
        if (this.lof.hasNext()) {
            this.gentypeVar.reset();
            this.gentype.reset();
            this.nmd.reset();
            this.lof.next();
            return;
        }
        if (this.effect.hasNext()) {
            this.gentypeVar.reset();
            this.gentype.reset();
            this.nmd.reset();
            this.lof.reset();
            this.effect.next();
            return;
        }
        if (this.var.hasNext()) {
            this.gentypeVar.reset();
            this.gentype.reset();
            this.nmd.reset();
            this.lof.reset();
            this.effect.reset();
            this.var.next();
            return;
        }
        throw new RuntimeException("Cannot go beyond this count: " + this);
    }

    public void reset() {
        this.type = 0;
        this.gentypeVar.reset();
        this.gentype.reset();
        this.nmd.reset();
        this.lof.reset();
        this.effect.reset();
        this.var.reset();
    }

    public void setMax(IteratorType iterType, int max2) {
        switch (iterType) {
            case VAR: {
                this.var.max = Math.max(max2, this.var.max);
                break;
            }
            case GENOTYPE: {
                this.gentype.max = Math.max(max2, this.gentype.max);
                break;
            }
            case GENOTYPE_VAR: {
                this.gentypeVar.max = Math.max(max2, this.gentypeVar.max);
                break;
            }
            case EFFECT: {
                this.effect.max = Math.max(max2, this.effect.max);
                break;
            }
            case LOF: {
                this.lof.max = Math.max(max2, this.lof.max);
                break;
            }
            case NMD: {
                this.nmd.max = Math.max(max2, this.nmd.max);
                break;
            }
            default: {
                throw new RuntimeException("Unknown iterator type '" + (Object)((Object)iterType) + "'");
            }
        }
    }

    public void setType(int type) {
        if (this.type != 0 && this.type != type) {
            throw new RuntimeException("Mixing 'ANY' and 'ALL' (or '*' and '?') is not supported!");
        }
        this.type = type;
    }

    public String toString() {
        String typeStr = "";
        if (this.type == -2) {
            typeStr = "ALL ";
        } else if (this.type == -1) {
            typeStr = "ANY ";
        }
        return typeStr + "[ var:" + this.var.current + " | eff:" + this.effect.current + " | gt:" + this.gentype.current + " | gtVar:" + this.gentypeVar.current + " ]";
    }

    public static enum IteratorType {
        VAR,
        EFFECT,
        GENOTYPE,
        GENOTYPE_VAR,
        LOF,
        NMD;

    }
}

