/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpsift.SnpSift;
import org.snpsift.lang.LangFactory;
import org.snpsift.lang.Value;
import org.snpsift.lang.expression.Expression;
import org.snpsift.lang.expression.FieldIterator;

public class SnpSiftCmdFilter
extends SnpSift {
    public static final String VCF_INFO_FILTER_DELETED = "FILTER_DELETED";
    boolean usePassField;
    boolean inverse;
    boolean exceptionIfNotFound;
    String expression;
    Expression expr;
    String filterId;
    String addFilterField;
    String rmFilterField;
    ArrayList<HashSet<String>> sets;
    EffFormatVersion formatVersion;

    public SnpSiftCmdFilter() {
    }

    public SnpSiftCmdFilter(String[] args) {
        super(args);
    }

    public void addSet(String fileName) {
        String file = Gpr.readFile(fileName);
        if (file.isEmpty()) {
            throw new RuntimeException("Could not read any entries from file '" + fileName + "'");
        }
        HashSet<String> set = new HashSet<String>();
        for (String str : file.split("\n")) {
            set.add(str.trim());
        }
        this.sets.add(set);
        if (this.verbose) {
            System.err.println("Adding set '" + fileName + "', " + set.size() + " elements.");
        }
    }

    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        boolean eval = this.evaluate(vcfEntry);
        if (this.usePassField) {
            if (eval) {
                vcfEntry.setFilter("PASS");
            } else {
                vcfEntry.addFilter(this.filterId);
            }
        }
        if (eval) {
            if (this.addFilterField != null) {
                vcfEntry.addFilter(this.addFilterField);
            }
            if (this.rmFilterField != null && vcfEntry.delFilter(this.rmFilterField)) {
                String filterDeleted = vcfEntry.getInfo(VCF_INFO_FILTER_DELETED);
                filterDeleted = filterDeleted == null ? this.rmFilterField : filterDeleted + "," + this.rmFilterField;
                vcfEntry.addInfo(VCF_INFO_FILTER_DELETED, filterDeleted);
            }
        }
        return eval;
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        super.annotateInit(vcfFile);
        try {
            this.parseExpression(this.expression);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.usage("Error parsing expression: '" + this.expression + "'");
        }
        return true;
    }

    boolean evaluate(VcfEntry vcfEntry) {
        FieldIterator fieldIterator = FieldIterator.get();
        fieldIterator.reset();
        boolean all = true;
        boolean any = false;
        if (this.debug) {
            Gpr.debug("VCF entry:" + vcfEntry.toStringNoGt());
        }
        while (true) {
            Value eval = this.expr.eval(vcfEntry);
            if (this.debug) {
                Gpr.debug("\tEval: " + eval + "\tFieldIterator: " + fieldIterator);
            }
            any |= eval.asBool();
            if (fieldIterator.getType() == -2 && !(all &= eval.asBool())) {
                boolean ret = this.inverse ^ all;
                if (this.debug) {
                    Gpr.debug("\tResult [ALL]: " + ret);
                }
                return ret;
            }
            if (fieldIterator.getType() == -1 && any) {
                boolean ret = this.inverse ^ any;
                if (this.debug) {
                    Gpr.debug("\tResult [ANY]: " + ret);
                }
                return ret;
            }
            if (!fieldIterator.hasNext()) break;
            fieldIterator.next();
        }
        boolean ret = false;
        if (fieldIterator.getType() == -2) {
            ret = all;
            if (this.debug) {
                Gpr.debug("\tResult [ALL]: " + ret);
            }
        } else {
            ret = any;
            if (this.debug) {
                Gpr.debug("\tResult [ANY]: " + ret);
            }
        }
        ret = this.inverse ^ ret;
        if (this.debug && this.inverse) {
            Gpr.debug("\tResult [INV]: " + ret);
        }
        return ret;
    }

    public List<VcfEntry> filter(String fileName, String expression, boolean createList) {
        this.vcfInputFile = fileName;
        this.expression = expression;
        return this.run(createList);
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> addHeader = super.headers();
        if (!this.filterId.isEmpty()) {
            String expr = this.expression.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim();
            addHeader.add(new VcfHeaderEntry("##FILTER=<ID=" + this.filterId + ",Description=\"" + (this.vcfHeaderAddProgramVersion ? VERSION_NO_NAME + ", " : "") + "Expression used: " + expr + "\">"));
        }
        if (this.rmFilterField != null) {
            addHeader.add(new VcfHeaderEntry("##FILTER=<ID=FILTER_DELETED,Description=\"Old filter fields removed by 'SnpSift filter -rmFilter' command\">"));
        }
        return addHeader;
    }

    @Override
    public void init() {
        super.init();
        this.verbose = false;
        this.usePassField = false;
        this.inverse = false;
        this.vcfInputFile = null;
        this.filterId = SnpSift.class.getSimpleName();
        this.addFilterField = null;
        this.rmFilterField = null;
        this.sets = new ArrayList();
        this.formatVersion = null;
        this.exceptionIfNotFound = false;
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-h": 
                    case "-help": {
                        this.usage(null);
                        break;
                    }
                    case "-f": 
                    case "--file": {
                        this.vcfInputFile = args[++i];
                        break;
                    }
                    case "-s": 
                    case "--set": {
                        this.addSet(args[++i]);
                        break;
                    }
                    case "-p": 
                    case "--pass": {
                        this.usePassField = true;
                        break;
                    }
                    case "--errmissing": {
                        this.exceptionIfNotFound = true;
                        break;
                    }
                    case "-i": 
                    case "--filterid": {
                        this.usePassField = true;
                        this.filterId = args[++i];
                        break;
                    }
                    case "-a": 
                    case "--addfilter": {
                        this.addFilterField = args[++i];
                        break;
                    }
                    case "-r": 
                    case "--rmfilter": {
                        this.rmFilterField = args[++i];
                        break;
                    }
                    case "-n": 
                    case "--inverse": {
                        this.inverse = true;
                        break;
                    }
                    case "--format": {
                        String formatVer = args[++i];
                        if (formatVer.equals("2")) {
                            this.formatVersion = EffFormatVersion.FORMAT_EFF_2;
                            break;
                        }
                        if (formatVer.equals("3")) {
                            this.formatVersion = EffFormatVersion.FORMAT_EFF_3;
                            break;
                        }
                        this.usage("Unknown format version '" + formatVer + "'");
                        break;
                    }
                    case "-e": 
                    case "--exprfile": {
                        String exprFile = args[++i];
                        if (this.verbose) {
                            System.err.println("Reading expression from file '" + exprFile + "'");
                        }
                        this.expression = Gpr.readFile(exprFile);
                        break;
                    }
                    default: {
                        this.usage("Unknown option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.expression == null) {
                this.expression = arg;
                continue;
            }
            if (this.vcfInputFile == null) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.expression == null) {
            this.usage("Missing filter expression!");
        }
    }

    public Expression parseExpression(String expression) throws Exception {
        if (this.debug) {
            Gpr.debug("Parse expression: \"" + expression + "\"");
        }
        LangFactory langFactory = new LangFactory(this.sets, this.formatVersion, this.exceptionIfNotFound);
        this.expr = langFactory.compile(expression);
        if (expression == null) {
            System.err.println("Fatal error: Cannot build expression tree.");
            System.exit(-1);
        }
        if (this.debug) {
            Gpr.debug("Expression: " + expression);
        }
        return this.expr;
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        if (this.debug) {
            Expression.debug = true;
        }
        LinkedList<VcfEntry> passEntries = createList ? new LinkedList<VcfEntry>() : null;
        this.showVcfHeader = !createList;
        VcfFileIterator vcfFile = this.openVcfInputFile();
        this.annotateInit(vcfFile);
        for (VcfEntry vcfEntry : vcfFile) {
            this.processVcfHeader(vcfFile);
            boolean show = this.annotate(vcfEntry);
            if (this.usePassField || this.addFilterField != null || this.rmFilterField != null) {
                show = true;
            }
            if (!show) continue;
            if (passEntries != null) {
                passEntries.add(vcfEntry);
                continue;
            }
            System.out.println(vcfEntry);
        }
        this.annotateFinish(vcfFile);
        return passEntries;
    }

    public void setAddFilterField(String addFilterField) {
        this.addFilterField = addFilterField;
    }

    public void setExceptionIfNotFound(boolean exceptionIfNotFound) {
        this.exceptionIfNotFound = exceptionIfNotFound;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    public void setFormatVersion(EffFormatVersion formatVersion) {
        this.formatVersion = formatVersion;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public void setRmFilterField(String rmFilterField) {
        this.rmFilterField = rmFilterField;
    }

    public void setSets(ArrayList<HashSet<String>> sets) {
        this.sets = sets;
    }

    public void setUsePassField(boolean usePassField) {
        this.usePassField = usePassField;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.out.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar filter [options] 'expression' [input.vcf]");
        System.err.println("Options:");
        System.err.println("\t-a|--addFilter <str>  : Add a string to FILTER VCF field if 'expression' is true. Default: '' (none)");
        System.err.println("\t-e|--exprFile <file>  : Read expression from a file");
        System.err.println("\t-f|--file <input.vcf> : VCF input file. Default: STDIN");
        System.err.println("\t-i|--filterId <str>   : ID for this filter (##FILTER tag in header and FILTER VCF field). Default: '" + this.filterId + "'");
        System.err.println("\t-n|--inverse          : Inverse. Show lines that do not match filter expression");
        System.err.println("\t-p|--pass             : Use 'PASS' field instead of filtering out VCF entries");
        System.err.println("\t-r|--rmFilter <str>   : Remove a string from FILTER VCF field if 'expression' is true (and 'str' is in the field). Default: '' (none)");
        System.err.println("\t-s|--set <file>       : Create a SET using 'file'");
        System.err.println("\t--errMissing          : Error is a field is missing. Default: " + this.exceptionIfNotFound);
        System.err.println("\t--format <format>     : SnpEff format version: {2, 3}. Default: " + (this.formatVersion == null ? "Auto" : this.formatVersion));
        System.err.println("\t--galaxy              : Used from Galaxy (expressions have been sanitized).");
        System.exit(-1);
    }
}

