/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationExonFrame {
    boolean verbose = false;
    boolean debug = false;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genomeName = "testLukas";
        String[] args = new String[]{"build", "-noLog", "-gff3", genomeName};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setDebug(this.debug);
        snpEff.setSupressOutput(!this.verbose);
        boolean ok = snpEff.run();
        Assert.assertTrue(ok);
        String configFile = "snpEff.config";
        Config config = new Config(genomeName, configFile);
        if (this.verbose) {
            System.out.println("Loading database");
        }
        SnpEffectPredictor snpEffectPredictor = config.loadSnpEffectPredictor();
        Transcript transcript = null;
        for (Gene gene : snpEffectPredictor.getGenome().getGenes()) {
            Iterator iterator2 = gene.iterator();
            while (iterator2.hasNext()) {
                Transcript tr;
                transcript = tr = (Transcript)iterator2.next();
            }
        }
        if (this.verbose) {
            Gpr.debug("Trasncript:" + transcript);
        }
        Assert.assertEquals(454127, transcript.getCdsStart());
        Assert.assertEquals(450599, transcript.getCdsEnd());
        String vcfFileName = "tests/testLukas.vcf";
        String[] argsEff = new String[]{"-classic", "-noHgvs", "-ud", "0", genomeName, vcfFileName};
        SnpEff cmd = new SnpEff(argsEff);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        ok = false;
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve.toStringNoGt());
            }
            EffectType expectedEffect = EffectType.valueOf(ve.getInfo("EXP_EFF"));
            String expectedAa = ve.getInfo("EXP_AA");
            String expectedCodon = ve.getInfo("EXP_CODON");
            boolean found = false;
            for (VcfEffect veff : ve.getVcfEffects()) {
                String eff = veff.getEffectType().toString();
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tExpecing: '" + (Object)((Object)expectedEffect) + "'\tFound: '" + eff + "'");
                    System.out.println("\t\tExpecing: '" + expectedAa + "'\tFound: '" + veff.getAa() + "'");
                    System.out.println("\t\tExpecing: '" + expectedCodon + "'\tFound: '" + veff.getCodon() + "'");
                }
                if (!veff.hasEffectType(expectedEffect) || veff.getAa() != null && !veff.getAa().isEmpty() && !expectedAa.equals(veff.getAa()) || veff.getCodon() != null && !veff.getCodon().isEmpty() && !expectedCodon.equals(veff.getCodon())) continue;
                ok = true;
                found = true;
            }
            if (found) continue;
            throw new RuntimeException("Cannot find expected effect '" + (Object)((Object)expectedEffect) + "', amino acid change '" + expectedAa + "' and codon change '" + expectedCodon + "'");
        }
        Assert.assertTrue("No match found", ok);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String genomeName = "testMacuminata";
        String[] args = new String[]{"build", "-noLog", genomeName};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        boolean ok = snpEff.run();
        Assert.assertTrue(ok);
    }
}

