/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.pdb.DistanceResult;
import org.snpeff.snpEffect.commandLine.SnpEffCmdPdb;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;

public class TestCasesIntegratioBuildPdb
extends TestCasesIntegrationBase {
    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genome = "testHg19Pdb";
        String pdbDir = "tests/pdb";
        String[] args = new String[]{"-pdbDir", pdbDir, genome};
        SnpEffCmdPdb cmd = new SnpEffCmdPdb();
        cmd.setVerbose(this.verbose);
        cmd.setDebug(this.debug);
        cmd.parseArgs(args);
        cmd.run(true);
        List<DistanceResult> distanceResults = cmd.getDistanceResults();
        boolean ok = false;
        for (DistanceResult dr : distanceResults) {
            ok |= dr.pdbId.equals("1A12") && dr.aaPos1 == 24 && dr.aaPos2 == 135;
            if (!this.verbose) continue;
            Gpr.debug("INTERACTION:\t" + dr);
        }
        Assert.assertTrue("Interaction not found!", ok);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String genome = "testHg19Pdb";
        String pdbDir = "tests/pdb";
        String[] args = new String[]{"-pdbDir", pdbDir, genome};
        SnpEffCmdPdb cmd = new SnpEffCmdPdb();
        cmd.setVerbose(this.verbose);
        cmd.setDebug(this.debug);
        cmd.parseArgs(args);
        cmd.run(true);
        List<DistanceResult> distanceResults = cmd.getDistanceResults();
        boolean ok = false;
        for (DistanceResult dr : distanceResults) {
            ok |= dr.pdbId.equals("4OVU") && dr.aaPos1 == 22 && dr.aaPos2 == 533 && dr.trId1.equals("NM_006218.2") && dr.trId2.equals("NM_181523.2");
            if (!this.verbose) continue;
            Gpr.debug(dr);
        }
        Assert.assertTrue("Interaction not found!", ok);
    }
}

