/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.geneSets;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.geneSets.GeneSets;
import org.snpeff.geneSets.GeneSetsRanked;

public class GeneSet
implements Comparable<GeneSet>,
Iterable<String>,
Serializable {
    public static boolean debug = false;
    private static final long serialVersionUID = 1L;
    String description;
    GeneSets geneSets;
    int maxRank;
    String name;
    long rankSum;
    int rankedGenesCount;
    int interestingGenesCount;
    HashSet<String> genes;

    public GeneSet(List<GeneSet> geneSetList, GeneSets geneSets) {
        this.geneSets = geneSets;
        this.maxRank = Integer.MIN_VALUE;
        this.rankSum = Integer.MIN_VALUE;
        this.interestingGenesCount = Integer.MIN_VALUE;
        this.rankedGenesCount = 0;
        this.genes = new HashSet();
        String namesAll = "";
        for (GeneSet geneSet : geneSetList) {
            this.genes.addAll(geneSet.genes);
            namesAll = namesAll + geneSet.getName() + " ";
        }
        this.setName(namesAll);
    }

    public GeneSet(String name, String description, GeneSets geneSets) {
        this.geneSets = geneSets;
        this.setName(name);
        this.description = description;
        this.maxRank = Integer.MIN_VALUE;
        this.rankSum = Integer.MIN_VALUE;
        this.interestingGenesCount = Integer.MIN_VALUE;
        this.rankedGenesCount = 0;
        this.genes = new HashSet();
    }

    public void addGene(String gene) {
        if (gene.isEmpty()) {
            return;
        }
        this.geneSets.add(gene);
        this.genes.add(gene);
    }

    @Override
    public int compareTo(GeneSet geneSet) {
        return this.getName().compareTo(geneSet.getName());
    }

    public int compareToNumbers(double n1, double n2, String name1, String name2, boolean descending) {
        int order;
        int n = order = descending ? -1 : 1;
        if (Double.isNaN(n1) && Double.isNaN(n2)) {
            return name1.compareTo(name2);
        }
        if (Double.isNaN(n1)) {
            return 1;
        }
        if (Double.isNaN(n2)) {
            return -1;
        }
        if (n1 < n2) {
            return -1 * order;
        }
        if (n1 > n2) {
            return 1 + order;
        }
        return name1.compareTo(name2);
    }

    public int countOverlap(GeneSet gs) {
        GeneSet gsSmall = this;
        GeneSet gsLarge = gs;
        if (this.size() > gs.size()) {
            gsSmall = gs;
            gsLarge = this;
        }
        int count2 = 0;
        for (String gene : gsSmall) {
            if (!gsLarge.hasGene(gene)) continue;
            ++count2;
        }
        return count2;
    }

    public List<String> genesSorted() {
        LinkedList<String> ll = new LinkedList<String>(this.genes);
        Collections.sort(ll);
        return ll;
    }

    public String getDescription() {
        return this.description;
    }

    public int getGeneCount() {
        return this.genes.size();
    }

    public HashSet<String> getGenes() {
        return this.genes;
    }

    public GeneSets getGeneSets() {
        return this.geneSets;
    }

    public HashSet<String> getInterestingGenes() {
        HashSet<String> g = new HashSet<String>(this.genes);
        g.retainAll(this.geneSets.getInterestingGenes());
        return g;
    }

    public int getInterestingGenesCount() {
        if (this.interestingGenesCount < 0) {
            this.interestingGenesCount = this.getInterestingGenes().size();
        }
        return this.interestingGenesCount;
    }

    public int getMaxRank() {
        return this.maxRank;
    }

    public String getName() {
        return this.name;
    }

    public int getRankedGenesCount() {
        return this.rankedGenesCount;
    }

    public long getRankSum() {
        return this.rankSum;
    }

    public boolean hasGene(String gene) {
        return this.genes.contains(gene);
    }

    public void intersection(GeneSet geneSet) {
        if (geneSet != null) {
            this.genes.retainAll(geneSet.genes);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.genes.iterator();
    }

    public long rankSum() {
        if (!this.geneSets.isRanked()) {
            throw new RuntimeException("Cannot calculate rank: This is not a ranked gene set ('" + this.name + "')!");
        }
        if (this.rankSum >= 0L) {
            return this.rankSum;
        }
        this.rankSum = 0L;
        this.rankedGenesCount = 0;
        this.maxRank = 0;
        GeneSetsRanked geneSetsRanked = (GeneSetsRanked)this.geneSets;
        for (String gene : this.getInterestingGenes()) {
            int r = geneSetsRanked.getRank(gene);
            if (r > 0) {
                ++this.rankedGenesCount;
                this.rankSum += (long)r;
            } else {
                throw new RuntimeException("This should never happen!!! Ranked symbol " + gene + " has rank = 0");
            }
            if (this.maxRank >= r) continue;
            this.maxRank = r;
        }
        return this.rankSum;
    }

    void reset() {
        this.maxRank = Integer.MIN_VALUE;
        this.rankSum = Integer.MIN_VALUE;
        this.interestingGenesCount = Integer.MIN_VALUE;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGeneSets(GeneSets geneSets) {
        this.geneSets = geneSets;
    }

    public void setMaxRank(int maxRank) {
        this.maxRank = maxRank;
    }

    public void setMinus(GeneSet geneSet) {
        if (geneSet != null) {
            this.genes.removeAll(geneSet.genes);
        }
    }

    public void setName(String geneSetName) {
        this.name = geneSetName;
    }

    public int size() {
        return this.genes.size();
    }

    public int sizeEffective() {
        int count2 = 0;
        for (String gene : this) {
            if (!this.geneSets.hasValue(gene)) continue;
            ++count2;
        }
        return count2;
    }

    public String toString() {
        return this.getName();
    }

    public String toStringAll() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName() + "\t" + this.description + "\tsize: " + this.size() + "\t");
        for (String gene : this.genesSorted()) {
            sb.append(gene + "\t");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void union(GeneSet geneSet) {
        if (geneSet != null) {
            this.genes.addAll(geneSet.genes);
        }
    }
}

