/*
 * Decompiled with CFR 0.152.
 */
package com.clineff.report;

import com.clineff.report.ReportBase;
import com.clineff.report.VariantReport;
import java.util.HashMap;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;

public abstract class ReportVcfEffect
extends ReportBase {
    public abstract boolean filter(VcfEffect var1);

    @Override
    public boolean filter(VcfEntry vcfEntry) {
        ++this.countVcfEntries;
        boolean ok = false;
        for (VcfEffect veff : vcfEntry.getVcfEffects()) {
            if (!this.filter(veff)) continue;
            ++this.countVcfEffPass;
            ok = true;
        }
        if (ok) {
            ++this.countVcfEntriesPass;
        }
        return ok;
    }

    protected boolean matchGenotype(int sampleNum, VcfEntry ve, VcfEffect veff) {
        if (sampleNum < 0) {
            return true;
        }
        VcfGenotype gt = ve.getVcfGenotype(sampleNum);
        if (gt.getGenotypeCode() <= 0) {
            return false;
        }
        if (ve.isBiAllelic()) {
            return true;
        }
        String genotype = veff.getGenotype();
        String[] alts = ve.getAlts();
        if (alts == null) {
            return false;
        }
        int[] nArray = gt.getGenotype();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int gtNum = nArray[n2];
            if (gtNum > 0 && gtNum < alts.length && alts[gtNum].equals(genotype)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean reportEffect(VcfEffect veff) {
        return this.filter(veff);
    }

    @Override
    protected HashMap<String, Object> reportHash(String sampleName) {
        HashMap<String, Object> data2 = super.reportHash(sampleName);
        int sampleNum = this.sampleNum(sampleName);
        for (VcfEntry ve : this.vcfEntries) {
            if (this.reportVcfEntry(ve)) {
                this.vcfEntryReport.add(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (!this.reportEffect(veff) || !this.matchGenotype(sampleNum, ve, veff)) continue;
                this.variantsReport.add(new VariantReport(ve, veff));
            }
        }
        data2.put("variantsReportCount", this.variantsReport.size());
        data2.put("variants", this.variantsReport);
        return data2;
    }

    public boolean reportVcfEntry(VcfEntry ve) {
        return false;
    }
}

