/*
 * Decompiled with CFR 0.152.
 */
package com.clineff.clinvar;

import org.snpeff.util.Gpr;

public enum ClinSig {
    NONE,
    UNCERTAIN,
    NOT_PROVIDED,
    BENIGN,
    LIKELY_BENIGN,
    LIKELY_PATHOGENIC,
    PATHOGENIC,
    DRUG_RESPONSE,
    HISTOCOMPATIBILITY,
    OTHER;


    public static ClinSig parse(int num) {
        switch (num) {
            case 0: {
                return UNCERTAIN;
            }
            case 1: {
                return NOT_PROVIDED;
            }
            case 2: {
                return BENIGN;
            }
            case 3: {
                return LIKELY_BENIGN;
            }
            case 4: {
                return LIKELY_PATHOGENIC;
            }
            case 5: {
                return PATHOGENIC;
            }
            case 6: {
                return DRUG_RESPONSE;
            }
            case 7: {
                return HISTOCOMPATIBILITY;
            }
            case 255: {
                return OTHER;
            }
        }
        throw new RuntimeException("Cannot parse ClinSig value '" + num + "'");
    }

    public static ClinSig parse(String str) {
        return ClinSig.parse(Gpr.parseIntSafe(str));
    }
}

