/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.reactome;

import java.util.ArrayList;
import java.util.Collections;
import org.snpeff.reactome.Entity;
import org.snpeff.util.Gpr;

public class Monitor {
    ArrayList<Entity> entities = new ArrayList();
    ArrayList<double[]> results = new ArrayList();
    ArrayList<String> labels = new ArrayList();

    public void add(Entity e) {
        this.entities.add(e);
    }

    public void addResults(String label) {
        double[] res = new double[this.size()];
        for (int i = 0; i < res.length; ++i) {
            Entity e = this.entities.get(i);
            res[i] = e.hasOutput() ? e.getOutput() : Double.NaN;
        }
        this.results.add(res);
        this.labels.add(label);
    }

    public void save(String fileName) {
        Gpr.toFile(fileName, this);
    }

    public int size() {
        return this.entities.size();
    }

    public int sizeResults() {
        return this.results.size();
    }

    public void sort() {
        Collections.sort(this.entities);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("enityId\tentityName");
        for (int j = 0; j < this.results.size(); ++j) {
            String lab = Gpr.sanityzeName(this.labels.get(j));
            out.append("\t" + lab);
        }
        out.append("\n");
        for (int i = 0; i < this.size(); ++i) {
            out.append(this.entities.get(i).getId());
            String entName = Gpr.sanityzeName(this.entities.get(i).getName());
            out.append("\t" + entName);
            for (int j = 0; j < this.results.size(); ++j) {
                out.append("\t" + this.results.get(j)[i]);
            }
            out.append("\n");
        }
        return out.toString();
    }
}

