/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.codonChange;

import java.util.List;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.codonChange.CodonChange;
import org.snpeff.interval.codonChange.CodonChangeMnp;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.Gpr;

public class CodonChangeMixed
extends CodonChangeMnp {
    public static boolean debug = false;
    int oldCodonCdsStart = -1;
    int oldCodonCdsEnd = -1;
    Variant mnp;
    Variant indel;
    CodonChange codonChangeMnp;
    CodonChange codonChangeIndel;
    VariantEffects variantEffectsOri;

    public CodonChangeMixed(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        super(variant, transcript, variantEffects);
        this.returnNow = false;
        this.requireNetCdsChange = false;
        int minLen = Math.min(variant.getReference().length(), variant.getAlt().length());
        String ref = variant.getReference();
        String refMnp = ref.substring(0, minLen);
        String refIndel = ref.substring(minLen);
        String alt = variant.getAlt();
        String altMnp = alt.substring(0, minLen);
        String altIndel = alt.substring(minLen);
        this.mnp = new Variant((Marker)variant.getChromosome(), variant.getStart(), refMnp, altMnp, variant.getId());
        this.indel = new Variant((Marker)variant.getChromosome(), variant.getStart() + minLen, refIndel, altIndel, variant.getId());
        this.variantEffectsOri = variantEffects;
        this.variantEffects = new VariantEffects();
        this.codonChangeMnp = CodonChange.factory(this.mnp, transcript, this.variantEffects);
        this.codonChangeIndel = CodonChange.factory(this.indel, transcript, this.variantEffects);
    }

    @Override
    public void codonChange() {
        this.codonOldNew();
        this.codonChangeMnp.codonChange();
        this.codonChangeIndel.codonChange();
        if (this.variantEffects.isEmpty()) {
            return;
        }
        this.variantEffects.sort();
        VariantEffect varEff = this.variantEffects.get(0);
        if (debug) {
            Gpr.debug("Mixed variant:" + this.variant + "\n\t\tSNP/MNP : " + this.mnp + "\n\t\tInDel   : " + this.indel + "\n\t\tEffects : ");
            for (VariantEffect ve : this.variantEffects) {
                System.err.println("\t\t\t" + ve.toStringSimple(true));
            }
        }
        varEff = this.effect(varEff.getMarker(), varEff.getEffectType(), false);
        for (int i = 0; i < this.variantEffects.size(); ++i) {
            List<EffectType> effTypes = this.variantEffects.get(i).getEffectTypes();
            for (int j = 0; j < effTypes.size(); ++j) {
                EffectType effType = effTypes.get(j);
                if (varEff.hasEffectType(effType)) continue;
                varEff.addEffect(effType);
            }
        }
        this.variantEffectsOri.add(varEff);
    }

    void codonNum() {
        if (this.transcript.isStrandPlus()) {
            this.codonStartNum = this.codonChangeMnp.codonStartNum;
            this.codonStartIndex = this.codonChangeMnp.codonStartIndex;
        } else {
            this.codonStartNum = this.codonChangeIndel.codonStartNum;
            this.codonStartIndex = this.codonChangeIndel.codonStartIndex;
        }
    }
}

