/*
 * Decompiled with CFR 0.152.
 */
package neobio.alignment;

import neobio.alignment.ScoringScheme;

public class BasicScoringScheme
extends ScoringScheme {
    protected int match_reward;
    protected int mismatch_penalty;
    protected int gap_cost;
    protected int max_absolute_score;

    public BasicScoringScheme(int n, int n2, int n3) {
        this(n, n2, n3, true);
    }

    public BasicScoringScheme(int n, int n2, int n3, boolean bl) {
        super(bl);
        this.match_reward = n;
        this.mismatch_penalty = n2;
        this.gap_cost = n3;
        this.max_absolute_score = Math.abs(n) >= Math.abs(n2) ? (Math.abs(n) >= Math.abs(n3) ? Math.abs(n) : Math.abs(n3)) : (Math.abs(n2) >= Math.abs(n3) ? Math.abs(n2) : Math.abs(n3));
    }

    public int scoreSubstitution(char c, char c2) {
        if (this.isCaseSensitive()) {
            if (c == c2) {
                return this.match_reward;
            }
            return this.mismatch_penalty;
        }
        if (Character.toLowerCase(c) == Character.toLowerCase(c2)) {
            return this.match_reward;
        }
        return this.mismatch_penalty;
    }

    public int scoreInsertion(char c) {
        return this.gap_cost;
    }

    public int scoreDeletion(char c) {
        return this.gap_cost;
    }

    public int maxAbsoluteScore() {
        return this.max_absolute_score;
    }

    public boolean isPartialMatchSupported() {
        return false;
    }

    public String toString() {
        return "Basic scoring scheme: match reward = " + this.match_reward + ", mismatch penalty = " + this.mismatch_penalty + ", gap cost = " + this.gap_cost;
    }
}

