/*
 * Decompiled with CFR 0.152.
 */
package org.forester.tools;

import org.forester.msa.Msa;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.PropertiesList;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public final class MutationInference {
    public static final void inferBranchEvents(Phylogeny phylogeny, String string) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            String string2;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isRoot()) continue;
            PhylogenyNode phylogenyNode2 = phylogenyNode.getParent();
            if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode2.getNodeData().isHasSequence()) {
                Object object;
                string2 = phylogenyNode.getNodeData().getSequence().getMolecularSequence();
                String string3 = phylogenyNode2.getNodeData().getSequence().getMolecularSequence();
                if (!ForesterUtil.isEmpty(string2) && !ForesterUtil.isEmpty(string3)) {
                    if (string2.length() != string3.length()) {
                        throw new IllegalArgumentException("sequences must be of equal length");
                    }
                    object = new PropertiesList();
                    for (int i = 0; i < string2.length(); ++i) {
                        if (string2.charAt(i) == string3.charAt(i)) continue;
                        Property property = new Property(string, i + 1 + ": " + string3.charAt(i) + " -> " + string2.charAt(i), "", "xsd:string", Property.AppliesTo.PARENT_BRANCH);
                        ((PropertiesList)object).addProperty(property);
                    }
                    phylogenyNode.getNodeData().setProperties((PropertiesList)object);
                    continue;
                }
                object = !ForesterUtil.isEmpty(string2) ? phylogenyNode.getName() : phylogenyNode2.getName();
                System.out.println("warning: node \"" + (String)object + "\" has no sequence associated");
                continue;
            }
            string2 = !phylogenyNode.getNodeData().isHasSequence() ? phylogenyNode.getName() : phylogenyNode2.getName();
            System.out.println("warning: node \"" + string2 + "\" has no sequence associated");
        }
    }

    public static final void addMolSeqs(Msa msa, Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string = phylogenyNode.getName();
            MolecularSequence molecularSequence = msa.getSequence(string);
            if (molecularSequence != null) {
                Sequence sequence = new Sequence();
                sequence.setMolecularSequenceAligned(true);
                sequence.setMolecularSequence(molecularSequence.getMolecularSequenceAsString());
                phylogenyNode.getNodeData().setSequence(sequence);
                continue;
            }
            throw new IllegalArgumentException("no sequence for node \"" + string + "\" found in MSA");
        }
    }
}

