/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public final class Accession
implements PhylogenyData,
Comparable<Accession> {
    private final String _comment;
    private final String _source;
    private final String _source_value;
    private final String _value;

    public Accession(String string) {
        this._value = string;
        this._source = "";
        this._comment = "";
        this._source_value = string;
    }

    public Accession(String string, String string2) {
        this._value = string;
        this._source = string2;
        this._comment = "";
        this._source_value = string2 != null ? string2 + string : string;
    }

    public Accession(String string, Source source) {
        this._value = string;
        this._source = source.toString();
        this._comment = "";
        this._source_value = (Object)((Object)source) + string;
    }

    public Accession(String string, String string2, String string3) {
        this._value = string;
        this._source = string2;
        this._comment = string3;
        this._source_value = string2 != null ? string2 + string : string;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getSource())) {
            stringBuffer.append(this.getSource());
            stringBuffer.append(": ");
        }
        stringBuffer.append(this.getValue());
        if (!ForesterUtil.isEmpty(this.getComment())) {
            stringBuffer.append(" (");
            stringBuffer.append(this.getComment());
            stringBuffer.append(")");
        }
        return stringBuffer;
    }

    @Override
    public int compareTo(Accession accession) {
        if (this.equals(accession)) {
            return 0;
        }
        return this._source_value.compareTo(accession._source_value);
    }

    @Override
    public PhylogenyData copy() {
        return new Accession(this.getValue(), this.getSource());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.isEqual((Accession)object);
    }

    public String getComment() {
        return this._comment;
    }

    public String getSource() {
        return this._source;
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return this._source_value.hashCode();
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (this == phylogenyData) {
            return true;
        }
        if (phylogenyData == null || this.getValue() == null) {
            return false;
        }
        Accession accession = (Accession)phylogenyData;
        if (this.getSource() != null && accession.getSource() != null) {
            return accession.getValue().equals(this.getValue()) && accession.getSource().equals(this.getSource());
        }
        return accession.getValue().equals(this.getValue());
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(":");
        stringBuffer.append("AC=");
        stringBuffer.append(ForesterUtil.replaceIllegalNhxCharacters(this.getValue()));
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (ForesterUtil.isEmpty(this.getSource())) {
            if (ForesterUtil.isEmpty(this.getComment())) {
                PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", "unknown", string);
            } else {
                PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", "unknown", "comment", this.getComment(), string);
            }
        } else if (ForesterUtil.isEmpty(this.getComment())) {
            PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", this.getSource(), string);
        } else {
            PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", this.getSource(), "comment", this.getComment(), string);
        }
    }

    public String toString() {
        return this.asText().toString();
    }

    public static enum Source {
        NCBI,
        REFSEQ,
        UNIPROT,
        GI,
        EMBL,
        ENSEMBL,
        UNKNOWN;


        public String toString() {
            switch (this) {
                case NCBI: {
                    return "ncbi";
                }
                case REFSEQ: {
                    return "refseq";
                }
                case UNIPROT: {
                    return "uniprot";
                }
                case GI: {
                    return "gi";
                }
                case EMBL: {
                    return "embl";
                }
                case ENSEMBL: {
                    return "ensembl";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

