/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

public final class NeighborJoiningF {
    private BasicSymmetricalDistanceMatrix _d;
    private float[][] _d_values;
    private final DecimalFormat _df;
    private PhylogenyNode[] _external_nodes;
    private int[] _mappings;
    private int _n;
    private float[] _r;
    private final boolean _verbose;
    private int _min_i;
    private int _min_j;

    private NeighborJoiningF() {
        this._verbose = false;
        this._df = null;
    }

    private NeighborJoiningF(boolean bl, int n) {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("maximum fraction digits for distances is out of range: " + n);
        }
        this._verbose = bl;
        this._df = new DecimalFormat();
        this._df.setMaximumFractionDigits(n);
        this._df.setRoundingMode(RoundingMode.HALF_UP);
    }

    public final Phylogeny execute(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        this.reset(basicSymmetricalDistanceMatrix);
        Phylogeny phylogeny = new Phylogeny();
        while (this._n > 2) {
            this.updateM();
            int n = this._min_i;
            int n2 = this._min_j;
            PhylogenyNode phylogenyNode = new PhylogenyNode();
            float f = this._d_values[this._mappings[n]][this._mappings[n2]];
            float f2 = f / 2.0f + (this._r[n] - this._r[n2]) / (float)(2 * (this._n - 2));
            float f3 = f - f2;
            if (this._df == null) {
                this.getExternalPhylogenyNode(n).setDistanceToParent(f2);
                this.getExternalPhylogenyNode(n2).setDistanceToParent(f3);
            } else {
                this.getExternalPhylogenyNode(n).setDistanceToParent(Double.parseDouble(this._df.format(f2)));
                this.getExternalPhylogenyNode(n2).setDistanceToParent(Double.parseDouble(this._df.format(f3)));
            }
            phylogenyNode.addAsChild(this.getExternalPhylogenyNode(n));
            phylogenyNode.addAsChild(this.getExternalPhylogenyNode(n2));
            if (this._verbose) {
                this.printProgress(n, n2);
            }
            this.calculateDistancesFromNewNode(n, n2, f);
            this._external_nodes[this._mappings[n]] = phylogenyNode;
            this.updateMappings(n2);
            --this._n;
        }
        double d = this._d_values[this._mappings[0]][this._mappings[1]] / 2.0f;
        if (this._df == null) {
            this.getExternalPhylogenyNode(0).setDistanceToParent(d);
            this.getExternalPhylogenyNode(1).setDistanceToParent(d);
        } else {
            double d2 = Double.parseDouble(this._df.format(d));
            this.getExternalPhylogenyNode(0).setDistanceToParent(d2);
            this.getExternalPhylogenyNode(1).setDistanceToParent(d2);
        }
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        phylogenyNode.addAsChild(this.getExternalPhylogenyNode(0));
        phylogenyNode.addAsChild(this.getExternalPhylogenyNode(1));
        if (this._verbose) {
            this.printProgress(0, 1);
        }
        phylogeny.setRoot(phylogenyNode);
        phylogeny.setRooted(false);
        return phylogeny;
    }

    public final List<Phylogeny> execute(List<BasicSymmetricalDistanceMatrix> list) {
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        for (BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix : list) {
            arrayList.add(this.execute(basicSymmetricalDistanceMatrix));
        }
        return arrayList;
    }

    private final void calculateDistancesFromNewNode(int n, int n2, float f) {
        int n3 = this._mappings[n];
        int n4 = this._mappings[n2];
        for (int i = 0; i < this._n; ++i) {
            if (i == n || i == n2) continue;
            int n5 = this._mappings[i];
            if (n < i) {
                if (n2 > i) {
                    this._d_values[n3][n5] = (this._d_values[n3][n5] + this._d_values[n5][n4] - f) / 2.0f;
                    continue;
                }
                this._d_values[n3][n5] = (this._d_values[n3][n5] + this._d_values[n4][n5] - f) / 2.0f;
                continue;
            }
            this._d_values[n5][n3] = n2 > i ? (this._d_values[n5][n3] + this._d_values[n5][n4] - f) / 2.0f : (this._d_values[n5][n3] + this._d_values[n4][n5] - f) / 2.0f;
        }
    }

    private final void calculateNetDivergences() {
        for (int i = 0; i < this._n; ++i) {
            float f = 0.0f;
            int n = this._mappings[i];
            for (int j = 0; j < this._n; ++j) {
                if (i == j) continue;
                if (i > j) {
                    f += this._d_values[this._mappings[j]][n];
                    continue;
                }
                f += this._d_values[n][this._mappings[j]];
            }
            this._r[i] = f;
        }
    }

    private final PhylogenyNode getExternalPhylogenyNode(int n) {
        return this._external_nodes[this._mappings[n]];
    }

    private final void initExternalNodes() {
        this._external_nodes = new PhylogenyNode[this._n];
        for (int i = 0; i < this._n; ++i) {
            this._external_nodes[i] = new PhylogenyNode();
            String string = this._d.getIdentifier(i);
            if (string != null) {
                this._external_nodes[i].setName(string);
            } else {
                this._external_nodes[i].setName(Integer.toString(i));
            }
            this._mappings[i] = i;
        }
    }

    private final void printProgress(int n, int n2) {
        System.out.println("Node " + this.printProgressNodeToString(this.getExternalPhylogenyNode(n)) + " joins " + this.printProgressNodeToString(this.getExternalPhylogenyNode(n2)));
    }

    private final String printProgressNodeToString(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal()) {
            if (ForesterUtil.isEmpty(phylogenyNode.getName())) {
                return Long.toString(phylogenyNode.getId());
            }
            return phylogenyNode.getName();
        }
        return phylogenyNode.getId() + " (" + (ForesterUtil.isEmpty(phylogenyNode.getChildNode1().getName()) ? Long.valueOf(phylogenyNode.getChildNode1().getId()) : phylogenyNode.getChildNode1().getName()) + "+" + (ForesterUtil.isEmpty(phylogenyNode.getChildNode2().getName()) ? Long.valueOf(phylogenyNode.getChildNode2().getId()) : phylogenyNode.getChildNode2().getName()) + ")";
    }

    private final void reset(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        this._n = basicSymmetricalDistanceMatrix.getSize();
        this._d = basicSymmetricalDistanceMatrix;
        this._r = new float[this._n];
        this._mappings = new int[this._n];
        this._d_values = new float[basicSymmetricalDistanceMatrix.getSize()][basicSymmetricalDistanceMatrix.getSize()];
        for (int i = 0; i < basicSymmetricalDistanceMatrix.getSize(); ++i) {
            for (int j = 0; j < basicSymmetricalDistanceMatrix.getSize(); ++j) {
                this._d_values[i][j] = (float)basicSymmetricalDistanceMatrix.getValue(i, j);
            }
        }
        this.initExternalNodes();
    }

    private final void updateM() {
        this.calculateNetDivergences();
        int n = this._n - 2;
        float f = Float.MAX_VALUE;
        this._min_i = -1;
        this._min_j = -1;
        for (int i = 1; i < this._n; ++i) {
            float f2 = this._r[i];
            int n2 = this._mappings[i];
            for (int j = 0; j < i; ++j) {
                float f3 = this._d_values[this._mappings[j]][n2] - (this._r[j] + f2) / (float)n;
                if (!(f3 < f)) continue;
                f = f3;
                this._min_i = j;
                this._min_j = i;
            }
        }
    }

    private final void updateMappings(int n) {
        for (int i = n; i < this._mappings.length - 1; ++i) {
            this._mappings[i] = this._mappings[i + 1];
        }
    }

    public static final NeighborJoiningF createInstance() {
        return new NeighborJoiningF();
    }

    public static final NeighborJoiningF createInstance(boolean bl, int n) {
        return new NeighborJoiningF(bl, n);
    }
}

