/*
 * Decompiled with CFR 0.152.
 */
package org.forester.clade_analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.clade_analysis.ResultMulti;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;
import org.forester.util.UserException;

public final class AnalysisMulti {
    private static final String UNKNOWN = "?";
    public static final double DEFAULT_CUTOFF_FOR_SPECIFICS = 0.5;
    public static final String DEFAULT_SEPARATOR = ".";
    public static final Pattern DEFAULT_QUERY_PATTERN_FOR_PPLACER_TYPE = Pattern.compile("_#\\d+_M=(.+)");

    public static ResultMulti execute(Phylogeny phylogeny) throws UserException {
        return AnalysisMulti.execute(phylogeny, DEFAULT_QUERY_PATTERN_FOR_PPLACER_TYPE, DEFAULT_SEPARATOR, 0.5);
    }

    public static ResultMulti execute(Phylogeny phylogeny, String string) throws UserException {
        return AnalysisMulti.execute(phylogeny, DEFAULT_QUERY_PATTERN_FOR_PPLACER_TYPE, string, 0.5);
    }

    public static ResultMulti execute(Phylogeny phylogeny, String string, double d) throws UserException {
        return AnalysisMulti.execute(phylogeny, DEFAULT_QUERY_PATTERN_FOR_PPLACER_TYPE, string, d);
    }

    public static ResultMulti execute(Phylogeny phylogeny, double d) throws UserException {
        return AnalysisMulti.execute(phylogeny, DEFAULT_QUERY_PATTERN_FOR_PPLACER_TYPE, DEFAULT_SEPARATOR, d);
    }

    public static ResultMulti execute(Phylogeny phylogeny, Pattern pattern, String string, double d) throws UserException {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("separator must not be null or empty");
        }
        AnalysisMulti.cleanUpExternalNames(phylogeny, string);
        List<PhylogenyNode> list = phylogeny.getNodes(pattern);
        ResultMulti resultMulti = new ResultMulti();
        resultMulti.setQueryNamePrefix(AnalysisMulti.obtainQueryPrefix(pattern, list));
        resultMulti.setTotalNumberOfMatches(list.size());
        resultMulti.setReferenceTreeNumberOfExternalNodes(phylogeny.getNumberOfExternalNodes() - list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string2;
            PhylogenyNode phylogenyNode = list.get(i);
            if (phylogenyNode.isRoot()) {
                throw new UserException("query " + pattern + " is root");
            }
            if (phylogenyNode.getParent().isRoot()) {
                throw new UserException("parent of query " + pattern + " is root");
            }
            PhylogenyNode phylogenyNode2 = phylogenyNode.getParent();
            PhylogenyNode phylogenyNode3 = phylogenyNode.getParent().getParent();
            while (phylogenyNode2.getNumberOfDescendants() == 1) {
                phylogenyNode2 = phylogenyNode2.getParent();
            }
            while (phylogenyNode3.getNumberOfDescendants() == 1) {
                phylogenyNode3 = phylogenyNode3.getParent();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PhylogenyNode phylogenyNode4 : phylogenyNode3.getAllExternalDescendants()) {
                string2 = phylogenyNode4.getName();
                Matcher matcher = pattern.matcher(string2);
                if (matcher.find()) continue;
                arrayList.add(string2);
            }
            String string3 = ForesterUtil.greatestCommonPrefix(arrayList, string);
            Matcher object2 = pattern.matcher(phylogenyNode.getName());
            string2 = null;
            if (!object2.find()) {
                throw new IllegalStateException("query pattern does not match [this should have never happened!]");
            }
            string2 = object2.group(1);
            double d2 = Double.parseDouble(string2);
            if (!ForesterUtil.isEmpty(string3)) {
                resultMulti.addGreatestCommonPrefix(string3, d2);
            } else {
                resultMulti.addGreatestCommonPrefix(UNKNOWN, d2);
            }
            String string4 = AnalysisMulti.analyzeSiblings(phylogenyNode2, phylogenyNode3, string, pattern);
            if (!ForesterUtil.isEmpty(string4)) {
                resultMulti.addGreatestCommonPrefixUp(string4, d2);
            } else {
                resultMulti.addGreatestCommonPrefixUp(UNKNOWN, d2);
            }
            String string5 = AnalysisMulti.analyzeSiblings(phylogenyNode, phylogenyNode2, string, pattern);
            if (!ForesterUtil.isEmpty(string5)) {
                resultMulti.addGreatestCommonPrefixDown(string5, d2);
                continue;
            }
            resultMulti.addGreatestCommonPrefixDown(UNKNOWN, d2);
        }
        resultMulti.analyze(d);
        return resultMulti;
    }

    private static final String obtainQueryPrefix(Pattern pattern, List<PhylogenyNode> list) throws UserException {
        String string = null;
        for (PhylogenyNode phylogenyNode : list) {
            String string2 = phylogenyNode.getName();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) continue;
            String string3 = string2.substring(0, matcher.start());
            if (ForesterUtil.isEmpty(string3)) {
                throw new UserException("query nodes with empty label prefix found: \"" + string3 + "\"");
            }
            if (string == null) {
                string = string3;
                continue;
            }
            if (string.equals(string3)) continue;
            throw new UserException("query nodes with different label prefixes found: \"" + string + "\" and \"" + string3 + "\"");
        }
        return string;
    }

    private static final void cleanUpExternalNames(Phylogeny phylogeny, String string) throws UserException {
        Pattern pattern = Pattern.compile("\\Q" + string + "\\E\\s+");
        Pattern pattern2 = Pattern.compile("\\s+\\Q" + string + "\\E");
        Pattern pattern3 = Pattern.compile("\\Q" + string + string + "\\E");
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string2 = phylogenyNode.getName().trim();
            if (ForesterUtil.isEmpty(string2)) {
                throw new UserException("external node(s) with empty annotation found");
            }
            if (string2.endsWith(string)) {
                throw new UserException("illegally formatted annotation found: annotations cannot end with separator: " + string2);
            }
            if (string2.startsWith(string)) {
                throw new UserException("illegally formatted annotation found: annotations cannot start with separator: " + string2);
            }
            if (pattern.matcher(string2).find()) {
                throw new UserException("illegally formatted annotation found: separator followed by whitespace: " + string2);
            }
            if (pattern2.matcher(string2).find()) {
                throw new UserException("illegally formatted annotation found: whitespace followed by separator: " + string2);
            }
            if (pattern3.matcher(string2).find()) {
                throw new UserException("illegally formatted annotation found: empty annotation level: " + string2);
            }
            phylogenyNode.setName(string2.replaceAll("\\s+", " "));
        }
    }

    private static final String analyzeSiblings(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2, String string, Pattern pattern) {
        int n = phylogenyNode.getChildNodeIndex();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<PhylogenyNode> list = phylogenyNode2.getDescendants();
        for (int i = 0; i < list.size(); ++i) {
            if (i == n) continue;
            PhylogenyNode phylogenyNode3 = list.get(i);
            for (PhylogenyNode phylogenyNode4 : phylogenyNode3.getAllExternalDescendants()) {
                String string2 = phylogenyNode4.getName();
                Matcher matcher = pattern.matcher(string2);
                if (matcher.find()) continue;
                arrayList.add(string2);
            }
        }
        String string3 = ForesterUtil.greatestCommonPrefix(arrayList, string);
        return string3;
    }

    public static final void performMapping(Pattern pattern, SortedMap<String, String> sortedMap, Phylogeny phylogeny, boolean bl) throws UserException {
        if (bl) {
            System.out.println();
            System.out.println("Id to annotation mapping:");
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string = phylogenyNode.getName().trim();
            if (ForesterUtil.isEmpty(string)) {
                throw new UserException("external node with empty name found");
            }
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) continue;
            if (!sortedMap.containsKey(string)) {
                throw new UserException("no mapping for \"" + string + "\" found");
            }
            phylogenyNode.setName(((String)sortedMap.get(string)).trim());
            if (!bl) continue;
            System.out.println(string + " -> " + phylogenyNode.getName());
        }
        if (bl) {
            System.out.println();
        }
    }

    public static final void performExtraProcessing1(Pattern pattern, Phylogeny phylogeny, String string, boolean bl, String string2, boolean bl2) throws UserException {
        if (bl2) {
            System.out.println();
            System.out.println("Extra annotation processing:");
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string3 = phylogenyNode.getName().trim();
            if (ForesterUtil.isEmpty(string3)) {
                throw new UserException("external node with empty name found");
            }
            if (pattern.matcher(string3).find()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            int n = string3.lastIndexOf(string);
            if (n < 0) continue;
            String string4 = string3.substring(n + 1).trim();
            if (ForesterUtil.isEmptyTrimmed(string4)) {
                throw new UserException("llegally formatted annotation: " + string3);
            }
            if (bl) {
                String string5 = string3.substring(0, n).trim();
                stringBuilder.append(string4);
                if (!ForesterUtil.isEmpty(string5)) {
                    stringBuilder.append(string2);
                    stringBuilder.append(string5);
                }
            } else {
                stringBuilder.append(string4);
            }
            phylogenyNode.setName(stringBuilder.toString());
            if (!bl2) continue;
            System.out.println(string3 + " -> " + phylogenyNode.getName());
        }
        if (bl2) {
            System.out.println();
        }
    }

    public static final void performSpecialProcessing1(Pattern pattern, Phylogeny phylogeny, String string, Pattern pattern2, boolean bl) throws UserException {
        if (bl) {
            System.out.println();
            System.out.println("Special annotation processing:");
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            String string2 = phylogenyNode.getName().trim();
            if (ForesterUtil.isEmpty(string2)) {
                throw new UserException("external node with empty name found");
            }
            if (pattern.matcher(string2).find()) continue;
            Matcher matcher = pattern2.matcher(string2);
            if (matcher.matches()) {
                int n = matcher.groupCount();
                if (n < 1) {
                    throw new UserException("illegal special pattern: " + pattern2 + " (need at least one capturing group)");
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 1; i <= n; ++i) {
                    String string3 = matcher.group(i);
                    if (ForesterUtil.isEmpty(string3)) continue;
                    if (i > 1) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(matcher.group(i));
                }
                phylogenyNode.setName(stringBuilder.toString());
                if (!bl) continue;
                System.out.println(string2 + " -> " + phylogenyNode.getName());
                continue;
            }
            throw new UserException("illegally formatted annotation for special processing: " + string2 + " (expected pattern: " + pattern2 + ")");
        }
        if (bl) {
            System.out.println();
        }
    }
}

