/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.util.ArrayList;
import java.util.List;
import org.forester.archaeopteryx.tools.ProcessRunning;

public class ProcessPool {
    private static final boolean DEBUG = true;
    private final ArrayList<ProcessRunning> _processes = new ArrayList();

    private ProcessPool() {
    }

    public static ProcessPool createInstance() {
        return new ProcessPool();
    }

    public synchronized ProcessRunning getProcessByIndex(int n) {
        return this.getProcesses().get(n);
    }

    public synchronized int size() {
        return this.getProcesses().size();
    }

    public synchronized ProcessRunning getProcessById(long l) {
        for (ProcessRunning processRunning : this.getProcesses()) {
            if (processRunning.getId() != l) continue;
            return processRunning;
        }
        return null;
    }

    public synchronized long addProcess(String string) {
        ProcessRunning processRunning = ProcessRunning.createInstance(string);
        long l = processRunning.getId();
        if (this.getProcessById(l) != null) {
            throw new IllegalStateException(" process with id " + l + "already exists");
        }
        this.getProcesses().add(processRunning);
        System.out.println(" pp: added: " + processRunning);
        return l;
    }

    public synchronized boolean removeProcess(long l) {
        int n = this.getProcessIndexById(l);
        if (n >= 0) {
            ProcessRunning processRunning = this.getProcessById(l);
            System.out.println(" pp: removing: " + processRunning);
            this.getProcesses().remove(n);
            return true;
        }
        return false;
    }

    private synchronized int getProcessIndexById(long l) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getProcesses().get(i).getId() != l) continue;
            return i;
        }
        return -1;
    }

    private synchronized List<ProcessRunning> getProcesses() {
        return this._processes;
    }
}

