/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.DefaultFurnitureCatalog;
import com.eteks.sweethome3d.io.DefaultPatternTexture;
import com.eteks.sweethome3d.io.DefaultTexturesCatalog;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.PatternsCatalog;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.UserPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUserPreferences
extends UserPreferences {
    public DefaultUserPreferences() {
        this(true, null);
    }

    DefaultUserPreferences(boolean bl, UserPreferences userPreferences) {
        if (userPreferences == null) {
            userPreferences = this;
        } else {
            this.setLanguage(userPreferences.getLanguage());
        }
        this.setFurnitureCatalog(bl ? new DefaultFurnitureCatalog(userPreferences, (File)null) : new FurnitureCatalog());
        this.setTexturesCatalog(bl ? new DefaultTexturesCatalog(userPreferences, (File)null) : new TexturesCatalog());
        ArrayList<TextureImage> arrayList = new ArrayList<TextureImage>();
        arrayList.add(new DefaultPatternTexture("foreground"));
        arrayList.add(new DefaultPatternTexture("reversedHatchUp"));
        arrayList.add(new DefaultPatternTexture("reversedHatchDown"));
        arrayList.add(new DefaultPatternTexture("reversedCrossHatch"));
        arrayList.add(new DefaultPatternTexture("background"));
        arrayList.add(new DefaultPatternTexture("hatchUp"));
        arrayList.add(new DefaultPatternTexture("hatchDown"));
        arrayList.add(new DefaultPatternTexture("crossHatch"));
        PatternsCatalog patternsCatalog = new PatternsCatalog(arrayList);
        this.setPatternsCatalog(patternsCatalog);
        this.setFurnitureCatalogViewedInTree(Boolean.parseBoolean(userPreferences.getLocalizedString(DefaultUserPreferences.class, "furnitureCatalogViewedInTree", new Object[0])));
        this.setNavigationPanelVisible(Boolean.parseBoolean(userPreferences.getLocalizedString(DefaultUserPreferences.class, "navigationPanelVisible", new Object[0])));
        this.setAerialViewCenteredOnSelectionEnabled(Boolean.parseBoolean(this.getOptionalLocalizedString(userPreferences, "aerialViewCenteredOnSelectionEnabled", "false")));
        this.setUnit(LengthUnit.valueOf(userPreferences.getLocalizedString(DefaultUserPreferences.class, "unit", new Object[0]).toUpperCase(Locale.ENGLISH)));
        this.setRulersVisible(Boolean.parseBoolean(userPreferences.getLocalizedString(DefaultUserPreferences.class, "rulersVisible", new Object[0])));
        this.setGridVisible(Boolean.parseBoolean(userPreferences.getLocalizedString(DefaultUserPreferences.class, "gridVisible", new Object[0])));
        String string = System.getProperty("os.name");
        this.setFurnitureViewedFromTop(Boolean.parseBoolean(this.getOptionalLocalizedString(userPreferences, "furnitureViewedFromTop." + string, userPreferences.getLocalizedString(DefaultUserPreferences.class, "furnitureViewedFromTop", new Object[0]))));
        this.setFloorColoredOrTextured(Boolean.parseBoolean(this.getOptionalLocalizedString(userPreferences, "roomFloorColoredOrTextured." + string, userPreferences.getLocalizedString(DefaultUserPreferences.class, "roomFloorColoredOrTextured", new Object[0]))));
        this.setWallPattern(patternsCatalog.getPattern(userPreferences.getLocalizedString(DefaultUserPreferences.class, "wallPattern", new Object[0])));
        String string2 = userPreferences.getLocalizedString(DefaultUserPreferences.class, "wallPattern", new Object[0]);
        if (string2 != null) {
            this.setNewWallPattern(patternsCatalog.getPattern(string2));
        }
        this.setNewWallThickness(Float.parseFloat(userPreferences.getLocalizedString(DefaultUserPreferences.class, "newWallThickness", new Object[0])));
        this.setNewWallHeight(Float.parseFloat(userPreferences.getLocalizedString(DefaultUserPreferences.class, "newHomeWallHeight", new Object[0])));
        this.setNewFloorThickness(Float.parseFloat(this.getOptionalLocalizedString(userPreferences, "newFloorThickness", "12")));
        this.setCheckUpdatesEnabled(Boolean.parseBoolean(this.getOptionalLocalizedString(userPreferences, "checkUpdatesEnabled", "false")));
        this.setAutoSaveDelayForRecovery(Integer.parseInt(this.getOptionalLocalizedString(userPreferences, "autoSaveDelayForRecovery", "0")));
        this.setRecentHomes(new ArrayList<String>());
        this.setRecentColors(new ArrayList<Integer>());
        this.setCurrency(this.getOptionalLocalizedString(userPreferences, "currency", null));
        for (String string3 : new String[]{"LevelName", "HomePieceOfFurnitureName", "RoomName", "LabelText"}) {
            String[] stringArray;
            String string4 = this.getOptionalLocalizedString(userPreferences, "autoCompletionStrings#" + string3, null);
            if (string4 == null || (stringArray = string4.trim().split(",")).length <= 0) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            this.setAutoCompletionStrings(string3, Arrays.asList(stringArray));
        }
    }

    private String getOptionalLocalizedString(UserPreferences userPreferences, String string, String string2) {
        try {
            return userPreferences.getLocalizedString(DefaultUserPreferences.class, string, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string2;
        }
    }

    @Override
    public void write() throws RecorderException {
        throw new UnsupportedOperationException("Default user preferences can't be written");
    }

    @Override
    public boolean languageLibraryExists(String string) throws RecorderException {
        throw new UnsupportedOperationException("Default user preferences can't manage language libraries");
    }

    @Override
    public void addLanguageLibrary(String string) throws RecorderException {
        throw new UnsupportedOperationException("Default user preferences can't manage language libraries");
    }

    @Override
    public boolean furnitureLibraryExists(String string) throws RecorderException {
        throw new UnsupportedOperationException("Default user preferences can't manage furniture libraries");
    }

    @Override
    public void addFurnitureLibrary(String string) throws RecorderException {
        throw new UnsupportedOperationException("Default user preferences can't manage furniture libraries");
    }

    @Override
    public boolean texturesLibraryExists(String string) throws RecorderException {
        throw new UnsupportedOperationException("Default user preferences can't manage textures libraries");
    }

    @Override
    public void addTexturesLibrary(String string) throws RecorderException {
        throw new UnsupportedOperationException("Default user preferences can't manage textures libraries");
    }

    @Override
    public List<Library> getLibraries() {
        throw new UnsupportedOperationException();
    }
}

