/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.ContentRecording;
import com.eteks.sweethome3d.io.HomeURLContent;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHomeOutputStream
extends FilterOutputStream {
    private int compressionLevel;
    private ContentRecording contentRecording;
    private List<Content> contents = new ArrayList<Content>();
    private Map<URL, List<String>> zipUrlEntriesCache = new HashMap<URL, List<String>>();

    public DefaultHomeOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 0, false);
    }

    public DefaultHomeOutputStream(OutputStream outputStream, int n, boolean bl) throws IOException {
        this(outputStream, n, bl ? ContentRecording.INCLUDE_TEMPORARY_CONTENT : ContentRecording.INCLUDE_ALL_CONTENT);
    }

    public DefaultHomeOutputStream(OutputStream outputStream, int n, ContentRecording contentRecording) throws IOException {
        super(outputStream);
        this.compressionLevel = n;
        this.contentRecording = contentRecording;
    }

    private static void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    public void writeHome(Home home) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(this.out);
        zipOutputStream.setLevel(this.compressionLevel);
        DefaultHomeOutputStream.checkCurrentThreadIsntInterrupted();
        zipOutputStream.putNextEntry(new ZipEntry("Home"));
        HomeObjectOutputStream homeObjectOutputStream = new HomeObjectOutputStream(zipOutputStream);
        homeObjectOutputStream.writeObject(home);
        homeObjectOutputStream.flush();
        zipOutputStream.closeEntry();
        int n = this.contents.size();
        for (int i = 0; i < n; ++i) {
            Content content = this.contents.get(i);
            String string = String.valueOf(i);
            if (content instanceof ResourceURLContent) {
                this.writeResourceZipEntries(zipOutputStream, string, (ResourceURLContent)content);
                continue;
            }
            if (content instanceof URLContent && ((URLContent)content).isJAREntry()) {
                URLContent uRLContent = (URLContent)content;
                if (uRLContent instanceof HomeURLContent) {
                    this.writeHomeZipEntries(zipOutputStream, string, (HomeURLContent)uRLContent);
                    continue;
                }
                this.writeZipEntries(zipOutputStream, string, uRLContent);
                continue;
            }
            this.writeZipEntry(zipOutputStream, string, content);
        }
        zipOutputStream.finish();
    }

    private void writeResourceZipEntries(ZipOutputStream zipOutputStream, String string, ResourceURLContent resourceURLContent) throws IOException {
        if (resourceURLContent.isMultiPartResource()) {
            if (resourceURLContent.isJAREntry()) {
                URL uRL = resourceURLContent.getJAREntryURL();
                String string2 = resourceURLContent.getJAREntryName();
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    String string3 = string2.substring(0, n + 1);
                    for (String string4 : this.getZipUrlEntries(uRL)) {
                        if (!string4.startsWith(string3)) continue;
                        URLContent uRLContent = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string4, "UTF-8").replace("+", "%20")));
                        this.writeZipEntry(zipOutputStream, string + string4.substring(n), uRLContent);
                    }
                } else {
                    this.writeZipEntry(zipOutputStream, string, resourceURLContent);
                }
            } else {
                try {
                    File[] fileArray;
                    File file = new File(resourceURLContent.getURL().toURI());
                    File file2 = new File(file.getParent());
                    for (File file3 : fileArray = file2.listFiles()) {
                        if (file3.isDirectory()) continue;
                        this.writeZipEntry(zipOutputStream, string + "/" + file3.getName(), new URLContent(file3.toURI().toURL()));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    IOException iOException = new IOException();
                    iOException.initCause(uRISyntaxException);
                    throw iOException;
                }
            }
        } else {
            this.writeZipEntry(zipOutputStream, string, resourceURLContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getZipUrlEntries(URL uRL) throws IOException {
        List<String> list = this.zipUrlEntriesCache.get(uRL);
        if (list == null) {
            list = new ArrayList<String>();
            this.zipUrlEntriesCache.put(uRL, list);
            ZipInputStream zipInputStream = null;
            try {
                ZipEntry zipEntry;
                zipInputStream = new ZipInputStream(uRL.openStream());
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    list.add(zipEntry.getName());
                }
            }
            finally {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
        }
        return list;
    }

    private void writeHomeZipEntries(ZipOutputStream zipOutputStream, String string, HomeURLContent homeURLContent) throws IOException {
        String string2 = homeURLContent.getJAREntryName();
        int n = string2.indexOf(47);
        if (n > 0) {
            URL uRL = homeURLContent.getJAREntryURL();
            String string3 = string2.substring(0, n + 1);
            for (String string4 : this.getZipUrlEntries(uRL)) {
                if (!string4.startsWith(string3)) continue;
                URLContent uRLContent = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string4, "UTF-8").replace("+", "%20")));
                this.writeZipEntry(zipOutputStream, string + string4.substring(n), uRLContent);
            }
        } else {
            this.writeZipEntry(zipOutputStream, string, homeURLContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipEntries(ZipOutputStream zipOutputStream, String string, URLContent uRLContent) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(uRLContent.getJAREntryURL().openStream());
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                URLContent uRLContent2 = new URLContent(new URL("jar:" + uRLContent.getJAREntryURL() + "!/" + URLEncoder.encode(string2, "UTF-8").replace("+", "%20")));
                this.writeZipEntry(zipOutputStream, string + "/" + string2, uRLContent2);
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipEntry(ZipOutputStream zipOutputStream, String string, Content content) throws IOException {
        DefaultHomeOutputStream.checkCurrentThreadIsntInterrupted();
        byte[] byArray = new byte[8192];
        InputStream inputStream = null;
        try {
            int n;
            zipOutputStream.putNextEntry(new ZipEntry(string));
            inputStream = content.openStream();
            while ((n = inputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private class HomeObjectOutputStream
    extends ObjectOutputStream {
        public HomeObjectOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
            if (DefaultHomeOutputStream.this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                this.enableReplaceObject(true);
            }
        }

        protected Object replaceObject(Object object) throws IOException {
            if (object instanceof TemporaryURLContent || object instanceof HomeURLContent || DefaultHomeOutputStream.this.contentRecording == ContentRecording.INCLUDE_ALL_CONTENT && object instanceof Content) {
                DefaultHomeOutputStream.this.contents.add((Content)object);
                String string = "";
                if (object instanceof URLContent) {
                    ResourceURLContent resourceURLContent;
                    URLContent uRLContent = (URLContent)object;
                    if (uRLContent.isJAREntry()) {
                        String string2 = uRLContent.getJAREntryName();
                        if (uRLContent instanceof HomeURLContent) {
                            int n = string2.indexOf(47);
                            if (n > 0) {
                                string = string2.substring(n);
                            }
                        } else if (uRLContent instanceof ResourceURLContent) {
                            int n;
                            ResourceURLContent resourceURLContent2 = (ResourceURLContent)uRLContent;
                            if (resourceURLContent2.isMultiPartResource() && (n = string2.lastIndexOf(47)) != -1) {
                                string = string2.substring(n);
                            }
                        } else {
                            string = "/" + string2;
                        }
                    } else if (uRLContent instanceof ResourceURLContent && (resourceURLContent = (ResourceURLContent)uRLContent).isMultiPartResource()) {
                        try {
                            string = "/" + new File(resourceURLContent.getURL().toURI()).getName();
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            IOException iOException = new IOException();
                            iOException.initCause(uRISyntaxException);
                            throw iOException;
                        }
                    }
                }
                return new URLContent(new URL("jar:file:temp!/" + (DefaultHomeOutputStream.this.contents.size() - 1) + string));
            }
            return object;
        }
    }
}

