/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d;

import com.eteks.sweethome3d.HomeFrameController;
import com.eteks.sweethome3d.MacOSXConfiguration;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.HomeView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.Timer;

public class HomeFramePane
extends JRootPane
implements View {
    private static final String FRAME_X_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameX";
    private static final String FRAME_Y_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameY";
    private static final String FRAME_WIDTH_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameWidth";
    private static final String FRAME_HEIGHT_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameHeight";
    private static final String FRAME_MAXIMIZED_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.FrameMaximized";
    private static final String SCREEN_WIDTH_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.ScreenWidth";
    private static final String SCREEN_HEIGHT_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.ScreenHeight";
    private final Home home;
    private final HomeApplication application;
    private final ContentManager contentManager;
    private final HomeFrameController controller;
    private static int newHomeCount;
    private int newHomeNumber;

    public HomeFramePane(Home home, HomeApplication homeApplication, ContentManager contentManager, HomeFrameController homeFrameController) {
        this.home = home;
        this.controller = homeFrameController;
        this.application = homeApplication;
        this.contentManager = contentManager;
        if (home.getName() == null) {
            this.newHomeNumber = ++newHomeCount;
        }
        HomeView homeView = this.controller.getHomeController().getView();
        this.setContentPane((JComponent)((Object)homeView));
    }

    public void displayView() {
        final JFrame jFrame = new JFrame(){
            {
                this.setRootPane(HomeFramePane.this);
            }
        };
        ArrayList<Image> arrayList = new ArrayList<Image>(3);
        arrayList.add(new ImageIcon(HomeFramePane.class.getResource("resources/frameIcon.png")).getImage());
        arrayList.add(new ImageIcon(HomeFramePane.class.getResource("resources/frameIcon32x32.png")).getImage());
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            arrayList.add(new ImageIcon(HomeFramePane.class.getResource("resources/frameIcon128x128.png")).getImage());
        }
        try {
            jFrame.getClass().getMethod("setIconImages", List.class).invoke((Object)jFrame, arrayList);
        }
        catch (Exception exception) {
            jFrame.setIconImage((Image)arrayList.get(0));
        }
        if (OperatingSystem.isMacOSXLionOrSuperior()) {
            MacOSXConfiguration.installToolBar(this);
        }
        this.updateFrameTitle(jFrame, this.home, this.application);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.computeFrameBounds(this.home, jFrame);
        this.getToolkit().setDynamicLayout(true);
        HomeView homeView = this.controller.getHomeController().getView();
        if (homeView instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)((Object)homeView);
            this.setJMenuBar(jRootPane.getJMenuBar());
            jRootPane.setJMenuBar(null);
        }
        this.addListeners(this.home, this.application, this.controller.getHomeController(), jFrame);
        jFrame.setVisible(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                jFrame.toFront();
            }
        });
    }

    private void addListeners(final Home home, final HomeApplication homeApplication, final HomeController homeController, final JFrame jFrame) {
        jFrame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if ((jFrame.getExtendedState() & 6) != 6) {
                    homeController.setVisualProperty(HomeFramePane.FRAME_WIDTH_VISUAL_PROPERTY, jFrame.getWidth());
                    homeController.setVisualProperty(HomeFramePane.FRAME_HEIGHT_VISUAL_PROPERTY, jFrame.getHeight());
                }
                Dimension dimension = HomeFramePane.this.getUserScreenSize();
                homeController.setVisualProperty(HomeFramePane.SCREEN_WIDTH_VISUAL_PROPERTY, dimension.width);
                homeController.setVisualProperty(HomeFramePane.SCREEN_HEIGHT_VISUAL_PROPERTY, dimension.height);
            }

            public void componentMoved(ComponentEvent componentEvent) {
                if ((jFrame.getExtendedState() & 6) != 6) {
                    homeController.setVisualProperty(HomeFramePane.FRAME_X_VISUAL_PROPERTY, jFrame.getX());
                    homeController.setVisualProperty(HomeFramePane.FRAME_Y_VISUAL_PROPERTY, jFrame.getY());
                }
            }
        });
        jFrame.setDefaultCloseOperation(0);
        WindowAdapter windowAdapter = new WindowAdapter(){
            private Component mostRecentFocusOwner;

            public void windowStateChanged(WindowEvent windowEvent) {
                homeController.setVisualProperty(HomeFramePane.FRAME_MAXIMIZED_VISUAL_PROPERTY, (jFrame.getExtendedState() & 6) == 6);
            }

            public void windowClosing(WindowEvent windowEvent) {
                homeController.close();
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                Component component = jFrame.getMostRecentFocusOwner();
                if (!(component instanceof JFrame) && component != null) {
                    this.mostRecentFocusOwner = component;
                }
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (this.mostRecentFocusOwner != null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            mostRecentFocusOwner.requestFocusInWindow();
                        }
                    });
                }
            }
        };
        jFrame.addWindowListener(windowAdapter);
        jFrame.addWindowStateListener(windowAdapter);
        homeApplication.getUserPreferences().addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(jFrame, this));
        homeApplication.addHomesListener(new CollectionListener<Home>(){

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                if (collectionEvent.getItem() == home && collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    homeApplication.removeHomesListener(this);
                    jFrame.dispose();
                }
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFramePane.this.updateFrameTitle(jFrame, home, homeApplication);
            }
        };
        home.addPropertyChangeListener(Home.Property.NAME, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.MODIFIED, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.RECOVERED, propertyChangeListener);
    }

    private void computeFrameBounds(Home home, final JFrame jFrame) {
        Integer n = (Integer)home.getVisualProperty(FRAME_X_VISUAL_PROPERTY);
        Integer n2 = (Integer)home.getVisualProperty(FRAME_Y_VISUAL_PROPERTY);
        Integer n3 = (Integer)home.getVisualProperty(FRAME_WIDTH_VISUAL_PROPERTY);
        Integer n4 = (Integer)home.getVisualProperty(FRAME_HEIGHT_VISUAL_PROPERTY);
        Boolean bl = (Boolean)home.getVisualProperty(FRAME_MAXIMIZED_VISUAL_PROPERTY);
        Integer n5 = (Integer)home.getVisualProperty(SCREEN_WIDTH_VISUAL_PROPERTY);
        Integer n6 = (Integer)home.getVisualProperty(SCREEN_HEIGHT_VISUAL_PROPERTY);
        Dimension dimension = this.getUserScreenSize();
        if (n != null && n2 != null && n3 != null && n4 != null && n5 != null && n6 != null && n5 <= dimension.width && n6 <= dimension.height) {
            final Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            if (bl != null && bl.booleanValue()) {
                if (OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                    Insets insets = jFrame.getInsets();
                    jFrame.setSize(dimension.width + insets.left + insets.right, dimension.height + insets.bottom);
                } else if (OperatingSystem.isLinux()) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            jFrame.setExtendedState(6);
                        }
                    });
                } else {
                    jFrame.setExtendedState(6);
                }
                jFrame.addWindowStateListener(new WindowAdapter(){

                    public void windowStateChanged(WindowEvent windowEvent) {
                        if ((windowEvent.getOldState() == 6 || OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7") && windowEvent.getOldState() == 0) && windowEvent.getNewState() == 0) {
                            if (OperatingSystem.isMacOSXLionOrSuperior()) {
                                new Timer(20, new ActionListener(){

                                    public void actionPerformed(ActionEvent actionEvent) {
                                        if (jFrame.getHeight() < 40) {
                                            ((Timer)actionEvent.getSource()).stop();
                                            jFrame.setBounds(rectangle);
                                        }
                                    }
                                }).start();
                            } else {
                                jFrame.setBounds(rectangle);
                            }
                            jFrame.removeWindowStateListener(this);
                        }
                    }
                });
            } else {
                jFrame.setBounds(rectangle);
                jFrame.setLocationByPlatform(!SwingTools.isRectangleVisibleAtScreen(rectangle));
            }
        } else {
            jFrame.setLocationByPlatform(true);
            jFrame.pack();
            jFrame.setSize(Math.min(dimension.width * 4 / 5, jFrame.getWidth()), Math.min(dimension.height * 4 / 5, jFrame.getHeight()));
            if (OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                int n7 = Integer.MAX_VALUE;
                int n8 = Integer.MAX_VALUE;
                int n9 = Integer.MIN_VALUE;
                int n10 = Integer.MIN_VALUE;
                for (Frame frame : Frame.getFrames()) {
                    if (!frame.isShowing() || frame.getBackground().getAlpha() == 0) continue;
                    n7 = Math.min(n7, frame.getX());
                    n8 = Math.min(n8, frame.getY());
                    n9 = Math.max(n9, frame.getX());
                    n10 = Math.max(n10, frame.getY());
                }
                n = n7 == Integer.MAX_VALUE || n7 >= 23 ? Integer.valueOf(0) : Integer.valueOf(n9 + 23);
                n2 = n8 == Integer.MAX_VALUE || n8 >= 23 ? Integer.valueOf(0) : Integer.valueOf(n10 + 23);
                jFrame.setLocation(n, n2);
            }
        }
    }

    private Dimension getUserScreenSize() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        return dimension;
    }

    private void updateFrameTitle(JFrame jFrame, Home home, HomeApplication homeApplication) {
        String string;
        String string2 = home.getName();
        if (string2 == null) {
            string = homeApplication.getUserPreferences().getLocalizedString(HomeFramePane.class, "untitled", new Object[0]);
            if (this.newHomeNumber > 1) {
                string = string + " " + this.newHomeNumber;
            }
        } else {
            string = this.contentManager.getPresentationName(string2, ContentManager.ContentType.SWEET_HOME_3D);
        }
        if (home.isRecovered()) {
            string = string + " " + homeApplication.getUserPreferences().getLocalizedString(HomeFramePane.class, "recovered", new Object[0]);
        }
        String string3 = string;
        if (OperatingSystem.isMacOSX()) {
            Boolean bl = home.isModified() || home.isRecovered();
            this.putClientProperty("windowModified", bl);
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                File file;
                this.putClientProperty("Window.documentModified", bl);
                if (string2 != null && (file = new File(string2)).exists()) {
                    this.putClientProperty("Window.documentFile", file);
                }
            }
            if (!jFrame.isVisible() && OperatingSystem.isMacOSXLionOrSuperior()) {
                try {
                    Class.forName("com.apple.eawt.FullScreenUtilities").getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE).invoke(null, jFrame, true);
                }
                catch (Exception exception) {}
            }
        } else {
            string3 = string3 + " - " + homeApplication.getName();
            if (home.isModified() || home.isRecovered()) {
                string3 = "* " + string3;
            }
        }
        jFrame.setTitle(string3);
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private WeakReference<JFrame> frame;
        private WeakReference<HomeFramePane> homeFramePane;

        public LanguageChangeListener(JFrame jFrame, HomeFramePane homeFramePane) {
            this.frame = new WeakReference<JFrame>(jFrame);
            this.homeFramePane = new WeakReference<HomeFramePane>(homeFramePane);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomeFramePane homeFramePane = (HomeFramePane)this.homeFramePane.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (homeFramePane == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                ((JFrame)this.frame.get()).applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                homeFramePane.updateFrameTitle((JFrame)this.frame.get(), homeFramePane.home, homeFramePane.application);
            }
        }
    }
}

