/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.weld.plugins.weld;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.kernel.weld.metadata.api.annotations.WeldEnabled;
import org.jboss.kernel.weld.plugins.dependency.WeldKernelControllerContext;
import org.jboss.kernel.weld.plugins.weld.AnnotatedTypeWrapper;
import org.jboss.kernel.weld.spi.annotated.MDRAnnotatedTypeFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.util.collection.ConcurrentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldFromMcRegistry {
    private static final WeldFromMcRegistry INSTANCE = new WeldFromMcRegistry();
    private final Map<KernelControllerContext, AnnotatedTypeWrapper> typesByContext = new ConcurrentHashMap<KernelControllerContext, AnnotatedTypeWrapper>();
    private final Set<KernelControllerContext> contextsWithNoType = new ConcurrentSet();
    private final Map<AnnotatedTypeWrapper, KernelControllerContext> contextsByType = new ConcurrentHashMap<AnnotatedTypeWrapper, KernelControllerContext>();

    public static WeldFromMcRegistry getInstance() {
        return INSTANCE;
    }

    public void registerBean(KernelControllerContext context) {
        if (context instanceof WeldKernelControllerContext) {
            this.registerBean(context, ((WeldKernelControllerContext)context).getWeldInjector().getType());
        } else {
            this.registerBean(context, null);
        }
    }

    private void registerBean(KernelControllerContext context, AnnotatedType<?> type) {
        if (!this.hasWeldEnabledAnnotation(context, type)) {
            return;
        }
        if (type != null) {
            AnnotatedTypeWrapper typeWrapper = new AnnotatedTypeWrapper(type);
            this.typesByContext.put(context, typeWrapper);
            this.contextsByType.put(typeWrapper, context);
        } else {
            this.contextsWithNoType.add(context);
        }
    }

    private boolean hasWeldEnabledAnnotation(KernelControllerContext context, AnnotatedType<?> type) {
        if (type != null) {
            return type.getAnnotation(WeldEnabled.class) != null;
        }
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelMetaDataRepository repository = kernel.getMetaDataRepository();
        MetaData metaData = repository.getMetaData((ControllerContext)context);
        return metaData.isAnnotationPresent(WeldEnabled.class);
    }

    public void unregisterBean(KernelControllerContext context) {
        AnnotatedTypeWrapper typeWrapper = this.typesByContext.remove(context);
        if (typeWrapper != null) {
            this.contextsByType.remove(typeWrapper);
        }
        this.contextsWithNoType.remove(context);
    }

    public void initializeTypes(BeanManager beanManager) {
        Iterator<KernelControllerContext> it = this.contextsWithNoType.iterator();
        while (it.hasNext()) {
            KernelControllerContext ctx = it.next();
            it.remove();
            AnnotatedType type = beanManager.createAnnotatedType(ctx.getBeanInfo().getClassInfo().getType());
            type = MDRAnnotatedTypeFactory.getInstance().decorateAnnotatedType(type, ctx);
            this.registerBean(ctx, type);
        }
    }

    public Collection<AnnotatedTypeWrapper> getTypes() {
        return Collections.unmodifiableCollection(this.typesByContext.values());
    }

    public KernelControllerContext getContext(AnnotatedType<?> type) {
        return this.contextsByType.get(new AnnotatedTypeWrapper(type));
    }
}

