/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializationHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCloseSequenceResponse;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;

final class RMCloseSequenceResponseSerializer
implements RMSerializer {
    private static final RMSerializer INSTANCE = new RMCloseSequenceResponseSerializer();

    private RMCloseSequenceResponseSerializer() {
    }

    static RMSerializer getInstance() {
        return INSTANCE;
    }

    @Override
    public final void deserialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMCloseSequenceResponse o = (RMCloseSequenceResponse)object;
        try {
            SOAPBody soapBody = soapMessage.getSOAPPart().getEnvelope().getBody();
            RMConstants wsrmConstants = provider.getConstants();
            QName closeSequenceResponseQName = wsrmConstants.getCloseSequenceResponseQName();
            SOAPElement closeSequenceResponseElement = RMSerializationHelper.getRequiredElement((SOAPElement)soapBody, closeSequenceResponseQName, "soap body");
            QName identifierQName = wsrmConstants.getIdentifierQName();
            SOAPElement identifierElement = RMSerializationHelper.getRequiredElement(closeSequenceResponseElement, identifierQName, closeSequenceResponseQName);
            String identifier = RMSerializationHelper.getRequiredTextContent(identifierElement, identifierQName);
            o.setIdentifier(identifier);
        }
        catch (SOAPException se) {
            throw new RMException("Unable to deserialize RM message", se);
        }
        catch (RuntimeException re) {
            throw new RMException("Unable to deserialize RM message", re);
        }
    }

    @Override
    public final void serialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMCloseSequenceResponse o = (RMCloseSequenceResponse)object;
        try {
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            RMConstants wsrmConstants = provider.getConstants();
            soapEnvelope.addNamespaceDeclaration(wsrmConstants.getPrefix(), wsrmConstants.getNamespaceURI());
            QName closeSequenceResponseQName = wsrmConstants.getCloseSequenceResponseQName();
            SOAPElement closeSequenceResponseElement = soapEnvelope.getBody().addChildElement(closeSequenceResponseQName);
            QName identifierQName = wsrmConstants.getIdentifierQName();
            closeSequenceResponseElement.addChildElement(identifierQName).setValue(o.getIdentifier());
        }
        catch (SOAPException se) {
            throw new RMException("Unable to serialize RM message", se);
        }
    }
}

