/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j.handlers;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.log4j.Appender;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.log4j.ConvertedLoggingEvent;

public final class Log4jAppenderHandler
extends ExtHandler {
    private volatile Appender appender = null;
    private static final AtomicReferenceFieldUpdater<Log4jAppenderHandler, Appender> appenderUpdater = AtomicReferenceFieldUpdater.newUpdater(Log4jAppenderHandler.class, Appender.class, "appender");

    public Log4jAppenderHandler(Appender appender) {
        appenderUpdater.set(this, appender);
    }

    public Appender getAppender() {
        return this.appender;
    }

    public void setAppender(Appender appender) {
        Log4jAppenderHandler.checkAccess();
        appenderUpdater.set(this, appender);
    }

    protected void doPublish(ExtLogRecord record) {
        Appender appender = this.appender;
        if (appender == null) {
            throw new IllegalStateException("Appender is closed");
        }
        ConvertedLoggingEvent event = new ConvertedLoggingEvent(record);
        appender.doAppend((LoggingEvent)event);
        super.doPublish(record);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        Log4jAppenderHandler.checkAccess();
        Appender appender = appenderUpdater.getAndSet(this, null);
        if (appender != null) {
            appender.close();
        }
    }
}

