/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.bisocket;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.BidirectionalClientInvoker;
import org.jboss.remoting.transport.bisocket.BisocketServerInvoker;
import org.jboss.remoting.transport.socket.SocketClientInvoker;
import org.jboss.remoting.transport.socket.SocketWrapper;
import org.jboss.remoting.util.SecurityUtility;

public class BisocketClientInvoker
extends SocketClientInvoker
implements BidirectionalClientInvoker {
    private static final Logger log = Logger.getLogger(BisocketClientInvoker.class);
    private static Map listenerIdToClientInvokerMap = Collections.synchronizedMap(new HashMap());
    private static Map listenerIdToCallbackClientInvokerMap = Collections.synchronizedMap(new HashMap());
    private static Map listenerIdToSocketsMap = new HashMap();
    private static Map listenerIdToControlSocketsMap = new HashMap();
    private static Timer timer;
    private static Object timerLock;
    protected String listenerId;
    private int pingFrequency = 5000;
    private int pingWindowFactor = 2;
    private int pingWindow = this.pingWindowFactor * this.pingFrequency;
    private int maxRetries = 10;
    private Socket controlSocket;
    private OutputStream controlOutputStream;
    private Object controlLock = new Object();
    private PingTimerTask pingTimerTask;
    protected boolean isCallbackInvoker;
    protected BooleanHolder pingFailed = new BooleanHolder(false);

    static BisocketClientInvoker getBisocketClientInvoker(String listenerId) {
        return (BisocketClientInvoker)listenerIdToClientInvokerMap.get(listenerId);
    }

    static BisocketClientInvoker getBisocketCallbackClientInvoker(String listenerId) {
        return (BisocketClientInvoker)listenerIdToCallbackClientInvokerMap.get(listenerId);
    }

    static void removeBisocketClientInvoker(String listenerId) {
        listenerIdToClientInvokerMap.remove(listenerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void transferSocket(String listenerId, Socket socket, boolean isControlSocket) {
        Object object;
        HashSet<Socket> sockets = null;
        if (isControlSocket) {
            object = listenerIdToControlSocketsMap;
            synchronized (object) {
                sockets = (HashSet<Socket>)listenerIdToControlSocketsMap.get(listenerId);
                if (sockets == null) {
                    sockets = new HashSet<Socket>();
                    listenerIdToControlSocketsMap.put(listenerId, sockets);
                }
            }
        }
        object = listenerIdToSocketsMap;
        synchronized (object) {
            sockets = (Set)listenerIdToSocketsMap.get(listenerId);
            if (sockets == null) {
                sockets = new HashSet();
                listenerIdToSocketsMap.put(listenerId, sockets);
            }
        }
        object = sockets;
        synchronized (object) {
            sockets.add(socket);
            sockets.notify();
        }
    }

    public BisocketClientInvoker(InvokerLocator locator) throws IOException {
        this(locator, null);
    }

    public BisocketClientInvoker(InvokerLocator locator, Map config) throws IOException {
        super(locator, config);
        if (this.configuration != null) {
            Object val;
            this.listenerId = (String)this.configuration.get("listenerId");
            if (this.listenerId != null) {
                this.isCallbackInvoker = true;
                listenerIdToCallbackClientInvokerMap.put(this.listenerId, this);
                log.debug((Object)(this + " :registered " + this.listenerId + " -> " + this));
            }
            if ((val = this.configuration.get("pingFrequency")) != null) {
                try {
                    int nVal;
                    this.pingFrequency = nVal = Integer.valueOf((String)val).intValue();
                    log.debug((Object)("Setting ping frequency to: " + this.pingFrequency));
                }
                catch (Exception e) {
                    log.warn((Object)("Could not convert pingFrequency value of " + val + " to an int value."));
                }
            }
            if ((val = this.configuration.get("pingWindowFactor")) != null && val instanceof String && ((String)val).length() > 0) {
                try {
                    this.pingWindowFactor = Integer.valueOf((String)val);
                    log.debug((Object)(this + " setting pingWindowFactor to " + this.pingWindowFactor));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Invalid format for \"pingWindowFactor\": " + val));
                }
            } else if (val != null) {
                log.warn((Object)"\"pingWindowFactor\" must be specified as a String");
            }
            this.pingWindow = this.pingWindowFactor * this.pingFrequency;
            val = this.configuration.get("maxRetries");
            if (val != null) {
                try {
                    int nVal;
                    this.maxRetries = nVal = Integer.valueOf((String)val).intValue();
                    log.debug((Object)("Setting retry limit: " + this.maxRetries));
                }
                catch (Exception e) {
                    log.warn((Object)("Could not convert maxRetries value of " + val + " to an int value."));
                }
            }
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getPingFrequency() {
        return this.pingFrequency;
    }

    public void setPingFrequency(int pingFrequency) {
        this.pingFrequency = pingFrequency;
    }

    public int getPingWindowFactor() {
        return this.pingWindowFactor;
    }

    public void setPingWindowFactor(int pingWindowFactor) {
        this.pingWindowFactor = pingWindowFactor;
        this.pingWindow = pingWindowFactor * this.pingFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleConnect() throws ConnectionFailedException {
        if (this.isCallbackInvoker) {
            HashSet sockets = null;
            Object object = listenerIdToControlSocketsMap;
            synchronized (object) {
                sockets = (HashSet)listenerIdToControlSocketsMap.get(this.listenerId);
                if (sockets == null) {
                    sockets = new HashSet();
                    listenerIdToControlSocketsMap.put(this.listenerId, sockets);
                }
            }
            object = sockets;
            synchronized (object) {
                if (sockets.isEmpty()) {
                    long wait = this.timeout;
                    long start = System.currentTimeMillis();
                    while (this.timeout == 0 || wait > 0L) {
                        try {
                            sockets.wait(wait);
                            break;
                        }
                        catch (InterruptedException e) {
                            log.debug((Object)"unexpected interrupt");
                            if (this.timeout <= 0) continue;
                            wait = (long)this.timeout - (System.currentTimeMillis() - start);
                        }
                    }
                }
                if (sockets.isEmpty()) {
                    throw new ConnectionFailedException("Timed out trying to create control socket");
                }
                Iterator it = sockets.iterator();
                this.controlSocket = (Socket)it.next();
                it.remove();
                try {
                    this.controlOutputStream = this.controlSocket.getOutputStream();
                }
                catch (IOException e1) {
                    throw new ConnectionFailedException("Unable to get control socket output stream");
                }
                log.debug((Object)("got control socket( " + this.listenerId + "): " + this.controlSocket));
                if (this.pingFrequency > 0) {
                    this.pingTimerTask = new PingTimerTask(this);
                    Object object2 = timerLock;
                    synchronized (object2) {
                        if (timer == null) {
                            timer = new Timer(true);
                        }
                        try {
                            timer.schedule((TimerTask)this.pingTimerTask, this.pingFrequency, (long)this.pingFrequency);
                        }
                        catch (IllegalStateException e) {
                            log.debug((Object)"Unable to schedule TimerTask on existing Timer", (Throwable)e);
                            timer = new Timer(true);
                            timer.schedule((TimerTask)this.pingTimerTask, this.pingFrequency, (long)this.pingFrequency);
                        }
                    }
                }
            }
            this.pool = new LinkedList();
            log.debug((Object)("Creating semaphore with size " + this.maxPoolSize));
            this.semaphore = new Semaphore((long)this.maxPoolSize);
            return;
        }
        super.handleConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleDisconnect() {
        if (this.listenerId != null) {
            if (this.isCallbackInvoker) {
                if (this.controlSocket != null) {
                    try {
                        this.controlSocket.close();
                    }
                    catch (IOException e) {
                        log.debug((Object)("unable to close control socket: " + this.controlSocket));
                    }
                }
                listenerIdToCallbackClientInvokerMap.remove(this.listenerId);
                for (SocketWrapper socketWrapper : this.pool) {
                    try {
                        socketWrapper.close();
                    }
                    catch (Exception exception) {}
                }
            } else {
                listenerIdToClientInvokerMap.remove(this.listenerId);
                super.handleDisconnect();
            }
            Map it = listenerIdToControlSocketsMap;
            synchronized (it) {
                listenerIdToControlSocketsMap.remove(this.listenerId);
            }
            Set sockets = null;
            Object object = listenerIdToSocketsMap;
            synchronized (object) {
                sockets = (Set)listenerIdToSocketsMap.remove(this.listenerId);
            }
            if (sockets != null) {
                object = sockets;
                synchronized (object) {
                    sockets.notifyAll();
                }
            }
            if (this.pingTimerTask != null) {
                this.pingTimerTask.shutDown();
            }
        } else {
            super.handleDisconnect();
        }
    }

    @Override
    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        InternalInvocation ii;
        InvocationRequest ir;
        Object o;
        String listenerId = null;
        if (invocation instanceof InvocationRequest && (o = (ir = (InvocationRequest)invocation).getParameter()) instanceof InternalInvocation && "addListener".equals((ii = (InternalInvocation)o).getMethodName()) && ir.getLocator() != null) {
            Map requestPayload = ir.getRequestPayload();
            listenerId = (String)requestPayload.get("listenerId");
            listenerIdToClientInvokerMap.put(listenerId, this);
            BisocketServerInvoker callbackServerInvoker = BisocketServerInvoker.getBisocketServerInvoker(listenerId);
            callbackServerInvoker.createControlConnection(listenerId, true);
        }
        return super.transport(sessionId, invocation, metadata, marshaller, unmarshaller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        long pingFailedWindow;
        if (!this.isCallbackInvoker) {
            return super.createSocket(address, port, timeout);
        }
        if (timeout < 0 && (timeout = this.getTimeout()) < 0) {
            timeout = 0;
        }
        HashSet sockets = null;
        Object object = listenerIdToSocketsMap;
        synchronized (object) {
            sockets = (HashSet)listenerIdToSocketsMap.get(this.listenerId);
            if (sockets == null) {
                sockets = new HashSet();
                listenerIdToSocketsMap.put(this.listenerId, sockets);
            }
        }
        object = this.controlLock;
        synchronized (object) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(this + " writing Bisocket.CREATE_ORDINARY_SOCKET on " + this.controlOutputStream));
            }
            try {
                this.controlOutputStream.write(4);
                if (log.isTraceEnabled()) {
                    log.trace((Object)(this + " wrote Bisocket.CREATE_ORDINARY_SOCKET"));
                }
                HashSet hashSet = sockets;
                synchronized (hashSet) {
                    if (!sockets.isEmpty()) {
                        Iterator it = sockets.iterator();
                        Socket socket = (Socket)it.next();
                        it.remove();
                        log.debug((Object)(this + " found socket (" + this.listenerId + "): " + socket));
                        return socket;
                    }
                }
            }
            catch (IOException e) {
                log.debug((Object)(this + " unable to write Bisocket.CREATE_ORDINARY_SOCKET"), (Throwable)e);
            }
        }
        long timeRemaining = timeout;
        long pingFailedTimeRemaining = pingFailedWindow = (long)(2 * this.pingWindow);
        long start = System.currentTimeMillis();
        OutputStream savedControlOutputStream = this.controlOutputStream;
        while (!(!this.isConnected() || this.pingFailed.flag && pingFailedTimeRemaining <= 0L || timeout != 0 && timeRemaining <= 0L)) {
            HashSet hashSet = sockets;
            synchronized (hashSet) {
                try {
                    sockets.wait(1000L);
                }
                catch (InterruptedException e) {
                    log.debug((Object)(this + " unexpected interrupt"));
                }
                if (!sockets.isEmpty()) {
                    Iterator it = sockets.iterator();
                    Socket socket = (Socket)it.next();
                    it.remove();
                    log.debug((Object)(this + " found socket (" + this.listenerId + "): " + socket));
                    return socket;
                }
            }
            if (savedControlOutputStream != this.controlOutputStream) {
                savedControlOutputStream = this.controlOutputStream;
                log.debug((Object)(this + " rewriting Bisocket.CREATE_ORDINARY_SOCKET on " + this.controlOutputStream));
                try {
                    this.controlOutputStream.write(4);
                    log.debug((Object)(this + " rewrote Bisocket.CREATE_ORDINARY_SOCKET"));
                }
                catch (IOException e) {
                    log.debug((Object)(this + " unable to rewrite Bisocket.CREATE_ORDINARY_SOCKET" + e.getMessage()));
                }
            }
            long elapsed = System.currentTimeMillis() - start;
            if (timeout > 0) {
                timeRemaining = (long)timeout - elapsed;
            }
            pingFailedTimeRemaining = pingFailedWindow - elapsed;
        }
        if (!this.isConnected()) {
            throw new IOException("Connection is closed");
        }
        if (this.pingFailed.flag) {
            throw new IOException("Unable to create socket");
        }
        throw new IOException("Timed out trying to create socket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceControlSocket(Socket socket) throws IOException {
        Object object = this.controlLock;
        synchronized (object) {
            if (this.controlSocket != null) {
                this.controlSocket.close();
            }
            log.debug((Object)(this + " replacing control socket: " + this.controlSocket));
            this.controlSocket = socket;
            log.debug((Object)(this + " control socket replaced by: " + socket));
            this.controlOutputStream = this.controlSocket.getOutputStream();
            log.debug((Object)("controlOutputStream replaced by: " + this.controlOutputStream));
        }
        if (this.pingTimerTask != null) {
            this.pingTimerTask.cancel();
        }
        if (this.pingFrequency > 0) {
            this.pingTimerTask = new PingTimerTask(this);
            object = timerLock;
            synchronized (object) {
                if (timer == null) {
                    timer = new Timer(true);
                }
                try {
                    timer.schedule((TimerTask)this.pingTimerTask, this.pingFrequency, (long)this.pingFrequency);
                }
                catch (IllegalStateException e) {
                    log.debug((Object)"Unable to schedule TimerTask on existing Timer", (Throwable)e);
                    timer = new Timer(true);
                    timer.schedule((TimerTask)this.pingTimerTask, this.pingFrequency, (long)this.pingFrequency);
                }
            }
        }
    }

    InvokerLocator getSecondaryLocator() throws Throwable {
        InternalInvocation ii = new InternalInvocation("getSecondaryInvokerLocator", null);
        InvocationRequest r = new InvocationRequest(null, null, ii, null, null, null);
        log.debug((Object)"getting secondary locator");
        Exception savedException = null;
        for (int i = 0; i < this.maxRetries; ++i) {
            try {
                Object o = this.invoke(r);
                log.debug((Object)("secondary locator: " + o));
                return (InvokerLocator)o;
            }
            catch (Exception e) {
                savedException = e;
                log.debug((Object)"unable to get secondary locator: trying again");
                continue;
            }
        }
        throw savedException;
    }

    @Override
    public InvokerLocator getCallbackLocator(Map metadata) {
        String transport = (String)metadata.get("callbackServerProtocol");
        String host = (String)metadata.get("callbackServerHost");
        String sPort = (String)metadata.get("callbackServerPort");
        int port = -1;
        if (sPort != null) {
            try {
                port = Integer.parseInt(sPort);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Can not set internal callback server port as configuration value (" + sPort + " is not a number.");
            }
        }
        return new InvokerLocator(transport, host, port, "callback", metadata);
    }

    private static Method getDeclaredMethod(final Class c, final String name, final Class[] parameterTypes) throws NoSuchMethodException {
        if (SecurityUtility.skipAccessControl()) {
            Method m = c.getDeclaredMethod(name, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    Method m = c.getDeclaredMethod(name, parameterTypes);
                    m.setAccessible(true);
                    return m;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NoSuchMethodException)e.getCause();
        }
    }

    static {
        timerLock = new Object();
    }

    static class BooleanHolder {
        public boolean flag;

        public BooleanHolder(boolean flag) {
            this.flag = flag;
        }
    }

    static class PingTimerTask
    extends TimerTask {
        private Object controlLock;
        private OutputStream controlOutputStream;
        private int maxRetries;
        private Exception savedException;
        private boolean running = true;
        private boolean pingSent;
        private BooleanHolder pingFailed;

        PingTimerTask(BisocketClientInvoker invoker) {
            this.controlLock = invoker.controlLock;
            this.controlOutputStream = invoker.controlOutputStream;
            this.maxRetries = invoker.getMaxRetries();
            this.pingFailed = invoker.pingFailed;
            this.pingFailed.flag = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutDown() {
            Object object = this.controlLock;
            synchronized (object) {
                this.controlOutputStream = null;
            }
            this.cancel();
            try {
                Method purge = BisocketClientInvoker.getDeclaredMethod(Timer.class, "purge", new Class[0]);
                purge.invoke((Object)timer, new Object[0]);
            }
            catch (Exception e) {
                log.debug((Object)"running with jdk 1.4: unable to purge Timer");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.pingSent = false;
            for (int i = 0; i < this.maxRetries; ++i) {
                try {
                    Object object = this.controlLock;
                    synchronized (object) {
                        if (!this.running) {
                            return;
                        }
                        this.controlOutputStream.write(1);
                    }
                    this.pingSent = true;
                    break;
                }
                catch (Exception e) {
                    this.savedException = e;
                    log.debug((Object)"Unable to send ping: trying again");
                    continue;
                }
            }
            if (!this.running) {
                return;
            }
            if (!this.pingSent) {
                log.warn((Object)"Unable to send ping: shutting down PingTimerTask", (Throwable)this.savedException);
                this.pingFailed.flag = true;
                this.shutDown();
            }
        }
    }
}

