/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.jboss.remoting.SerializableStore;
import org.jboss.remoting.util.SecurityUtility;

public class CallbackStoreWrapper
implements SerializableStore {
    private SerializableStore proxy;

    public CallbackStoreWrapper(SerializableStore proxy) {
        this.proxy = proxy;
    }

    @Override
    public void add(final Serializable object) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.add(object);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    CallbackStoreWrapper.this.proxy.add(object);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    @Override
    public void create() throws Exception {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.create();
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    CallbackStoreWrapper.this.proxy.create();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }

    @Override
    public void destroy() {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.destroy();
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CallbackStoreWrapper.this.proxy.destroy();
                return null;
            }
        });
    }

    @Override
    public Object getNext() throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            return this.proxy.getNext();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return CallbackStoreWrapper.this.proxy.getNext();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    @Override
    public boolean getPurgeOnShutdown() {
        if (SecurityUtility.skipAccessControl()) {
            return this.proxy.getPurgeOnShutdown();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(CallbackStoreWrapper.this.proxy.getPurgeOnShutdown());
            }
        });
    }

    @Override
    public void purgeFiles() {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.purgeFiles();
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CallbackStoreWrapper.this.proxy.purgeFiles();
                return null;
            }
        });
    }

    @Override
    public void setConfig(final Map config) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.setConfig(config);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CallbackStoreWrapper.this.proxy.setConfig(config);
                return null;
            }
        });
    }

    @Override
    public void setPurgeOnShutdown(final boolean purgeOnShutdown) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.setPurgeOnShutdown(purgeOnShutdown);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CallbackStoreWrapper.this.proxy.setPurgeOnShutdown(purgeOnShutdown);
                return null;
            }
        });
    }

    @Override
    public int size() {
        if (SecurityUtility.skipAccessControl()) {
            return this.proxy.size();
        }
        return (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Integer(CallbackStoreWrapper.this.proxy.size());
            }
        });
    }

    @Override
    public void start() throws Exception {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.start();
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    CallbackStoreWrapper.this.proxy.start();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Exception)e.getCause();
        }
    }

    @Override
    public void stop() {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.stop();
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CallbackStoreWrapper.this.proxy.stop();
                return null;
            }
        });
    }
}

