/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.ejb3.cache.ObjectStore;
import org.jboss.ejb3.cache.PassivatingCache;
import org.jboss.ejb3.cache.PassivationManager;
import org.jboss.ejb3.cache.StatefulObjectFactory;
import org.jboss.ejb3.cache.grouped.GroupedPassivatingCache;
import org.jboss.ejb3.cache.grouped.PassivationGroup;
import org.jboss.ejb3.cache.impl.PassivationGroupImpl;
import org.jboss.ejb3.cache.impl.SimplePassivatingCache;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedPassivatingCacheImpl<T extends Identifiable & Serializable>
implements GroupedPassivatingCache<T> {
    private static final Logger log = Logger.getLogger(GroupedPassivatingCacheImpl.class);
    private PassivatingCache<PassivationGroup> groupCache;
    private SimplePassivatingCache<Entry> delegate;
    private Map<Object, Entry> storage = new HashMap<Object, Entry>();

    public GroupedPassivatingCacheImpl(StatefulObjectFactory<T> factory, PassivationManager<T> passivationManager, ObjectStore<T> store, PassivatingCache<PassivationGroup> groupCache) {
        assert (groupCache != null) : "groupCache is null";
        assert (passivationManager != null) : "passivationManager is null";
        this.groupCache = groupCache;
        EntryContainer container = new EntryContainer(factory, passivationManager, store);
        this.delegate = new SimplePassivatingCache<Entry>(container, container, container);
    }

    @Override
    public void passivate(Object key) {
        this.delegate.passivate(key);
    }

    @Override
    public T create(Class<?>[] initTypes, Object[] initValues) {
        return this.delegate.create(initTypes, (Object[])initValues).obj;
    }

    @Override
    public T get(Object key) throws NoSuchEJBException {
        return this.delegate.get((Object)key).obj;
    }

    @Override
    public T peek(Object key) throws NoSuchEJBException {
        return this.delegate.peek((Object)key).obj;
    }

    @Override
    public void release(T obj) {
        this.delegate.releaseByKey(obj.getId());
    }

    @Override
    public void remove(Object key) {
        this.delegate.remove(key);
    }

    @Override
    public void setGroup(T obj, PassivationGroup group) {
        Object key = obj.getId();
        Entry entry = this.delegate.peek(key);
        if (entry.group != null) {
            throw new IllegalStateException("object " + key + " already associated with a passivation group");
        }
        entry.group = (PassivationGroupImpl)group;
        entry.groupId = group.getId();
        entry.group.addMember(key, entry);
    }

    public void setName(String name) {
        this.delegate.setName(name + "-delegate");
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.delegate.setSessionTimeout(sessionTimeout);
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryContainer
    implements StatefulObjectFactory<Entry>,
    PassivationManager<Entry>,
    ObjectStore<Entry> {
        private StatefulObjectFactory<T> factory;
        private PassivationManager<T> passivationManager;
        private ObjectStore<T> store;

        EntryContainer(StatefulObjectFactory<T> factory, PassivationManager<T> passivationManager, ObjectStore<T> store) {
            this.factory = factory;
            this.passivationManager = passivationManager;
            this.store = store;
        }

        @Override
        public Entry create(Class<?>[] initTypes, Object[] initValues) {
            return new Entry(GroupedPassivatingCacheImpl.this, (Identifiable)this.factory.create(initTypes, initValues));
        }

        @Override
        public void destroy(Entry entry) {
            this.factory.destroy(entry.obj);
        }

        @Override
        public Entry load(Object key) {
            Entry entry = (Entry)GroupedPassivatingCacheImpl.this.storage.get(key);
            if (entry != null) {
                log.trace((Object)("entry = " + entry));
                return entry;
            }
            Object obj = this.store.load(key);
            if (obj == null) {
                return null;
            }
            return new Entry(GroupedPassivatingCacheImpl.this, obj);
        }

        @Override
        public void postActivate(Entry entry) {
            log.trace((Object)("post activate " + entry));
            if (entry.obj == null) {
                if (entry.group == null) {
                    entry.group = (PassivationGroupImpl)GroupedPassivatingCacheImpl.this.groupCache.peek(entry.groupId);
                }
                entry.obj = (Identifiable)entry.group.getMember(entry.id);
            }
            this.passivationManager.postActivate((Serializable)entry.obj);
        }

        @Override
        public void prePassivate(Entry entry) {
            log.trace((Object)("pre passivate " + entry));
            this.passivationManager.prePassivate((Serializable)entry.obj);
            if (entry.group != null) {
                entry.group.removeActive(entry.id);
                entry.group.prePassivate();
                GroupedPassivatingCacheImpl.this.groupCache.passivate(entry.groupId);
                entry.group = null;
                entry.obj = null;
            }
        }

        @Override
        public void store(Entry entry) {
            log.trace((Object)("store " + entry));
            if (entry.groupId == null) {
                this.store.store(entry.obj);
            } else {
                GroupedPassivatingCacheImpl.this.storage.put(entry.id, entry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry
    implements Identifiable,
    Serializable {
        private static final long serialVersionUID = 1L;
        Object id;
        T obj;
        PassivationGroupImpl group;
        Object groupId;
        final /* synthetic */ GroupedPassivatingCacheImpl this$0;

        Entry(T obj) {
            this.this$0 = var1_1;
            assert (obj != null) : "obj is null";
            this.obj = obj;
            this.id = obj.getId();
        }

        @Override
        public Object getId() {
            return this.id;
        }

        void passivate() {
            this.group = null;
            this.this$0.delegate.passivate(this.id);
            this.obj = null;
        }

        public String toString() {
            return super.toString() + "{id=" + this.id + ",obj=" + this.obj + ",groupId=" + this.groupId + ",group=" + this.group + "}";
        }
    }
}

