/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationConfigParser {
    public Set<AppConfigurationEntry> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        LinkedHashSet<AppConfigurationEntry> entries = new LinkedHashSet<AppConfigurationEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            AppConfigurationEntry entry = null;
            if (!"login-module".equals(StaxParserUtil.getStartElementName(peekedStartElement))) break;
            entry = this.getEntry(xmlEventReader);
            entries.add(entry);
        }
        return entries;
    }

    private AppConfigurationEntry getEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        StartElement loginModuleElement = (StartElement)xmlEvent;
        Iterator<Attribute> attrs = loginModuleElement.getAttributes();
        while (attrs.hasNext()) {
            Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"flag".equals(attQName.getLocalPart())) continue;
            controlFlag = this.getControlFlag(attributeValue);
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        return new AppConfigurationEntry(codeName, controlFlag, options);
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flag) {
        if ("required".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("sufficient".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("optional".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("requisite".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        throw new RuntimeException(flag + " is not recognized");
    }
}

