/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl.config;

import java.io.InputStream;
import org.jboss.logging.Logger;
import org.jboss.security.acl.config.ACLConfigParser;
import org.jboss.security.acl.config.ACLConfigParserStax;
import org.jboss.security.acl.config.ACLConfiguration;
import org.jboss.security.acl.config.SecurityActions;

public class ACLConfigurationFactory {
    private static Logger log = Logger.getLogger(ACLConfigurationFactory.class);
    private static ACLConfigParser aclParser = null;

    public static ACLConfiguration getConfiguration(InputStream aclConfigFileStream) {
        if (aclParser == null) {
            throw new IllegalStateException("ACL Config Parser is null");
        }
        return aclParser.getConfiguration(aclConfigFileStream);
    }

    public static void setConfigParser(ACLConfigParser aclParserPassed) {
        aclParser = aclParserPassed;
    }

    static {
        String className = "org.jboss.security.acl.config.ACLConfigParserJBossXB";
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            Class<?> clazz = tcl.loadClass(className);
            aclParser = (ACLConfigParser)clazz.newInstance();
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Exception initializing ACL Config Parser based on JBossXB", (Throwable)e);
            }
            aclParser = new ACLConfigParserStax();
        }
    }
}

