/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.file;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.beans.metadata.api.annotations.Install;
import org.jboss.beans.metadata.api.annotations.Uninstall;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.deployer.FileMatcher;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStructure
extends AbstractVFSStructureDeployer
implements VirtualFileFilter {
    private static Set<String> fileSuffixes = new CopyOnWriteArraySet<String>(Arrays.asList("-service.xml", "-beans.xml", "-ds.xml", "-aop.xml"));
    private Set<FileMatcher> fileMatchers = new CopyOnWriteArraySet<FileMatcher>();

    public FileStructure() {
    }

    public FileStructure(Set<String> suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException("Null suffixes");
        }
        fileSuffixes.clear();
        fileSuffixes.addAll(suffixes);
    }

    public Set<String> getSuffixes() {
        return fileSuffixes;
    }

    public static boolean addFileSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return fileSuffixes.add(suffix);
    }

    public static boolean removeFileSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return fileSuffixes.remove(suffix);
    }

    @Install
    public boolean addFileMatcher(FileMatcher fm) {
        return this.fileMatchers.add(fm);
    }

    @Uninstall
    public boolean removeFileMatcher(FileMatcher fm) {
        return this.fileMatchers.remove(fm);
    }

    public static boolean isKnownFile(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        for (String suffix : fileSuffixes) {
            if (!name.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkFileMatchers(VirtualFile file) {
        for (FileMatcher fm : this.fileMatchers) {
            if (!fm.isDeployable(file)) continue;
            return true;
        }
        return false;
    }

    public boolean accepts(VirtualFile file) {
        return this.checkFileMatchers(file);
    }

    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        ContextInfo context = null;
        VirtualFile file = structureContext.getFile();
        try {
            boolean trace = log.isTraceEnabled();
            if (FileStructure.isLeaf((VirtualFile)file)) {
                boolean isFile = false;
                if (trace) {
                    log.trace((Object)(file + " is a leaf"));
                }
                if (!structureContext.isTopLevel()) {
                    if (!FileStructure.isKnownFile(file.getName()) && !this.checkFileMatchers(file)) {
                        if (trace) {
                            log.trace((Object)"... no - it is not a top level file and not a known name");
                        }
                    } else {
                        if (trace) {
                            log.trace((Object)"... ok - not a top level file but it is a known name");
                        }
                        isFile = true;
                    }
                } else {
                    if (trace) {
                        log.trace((Object)"... ok - it is a top level file");
                    }
                    isFile = true;
                }
                if (isFile) {
                    context = this.createContext(structureContext);
                }
                if (trace) {
                    log.trace((Object)(file + " isFile: " + isFile));
                }
                return isFile;
            }
            if (trace) {
                log.trace((Object)"... no - not a file.");
            }
            return false;
        }
        catch (Exception e) {
            if (context != null) {
                structureContext.removeChild(context);
            }
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
    }
}

