/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassPool;

public class WeavingRegistry {
    private static final Map<ClassPool, Collection<String>> loadedButNotWovenClasses = new ConcurrentHashMap<ClassPool, Collection<String>>();

    public static void setClassLoadedButNotWoven(ClassPool classPool, String classname) {
        Collection<String> notWovenClasses = loadedButNotWovenClasses.get(classPool);
        if (notWovenClasses == null) {
            notWovenClasses = new HashSet<String>();
            loadedButNotWovenClasses.put(classPool, notWovenClasses);
        }
        notWovenClasses.add(classname);
    }

    public static boolean isClassLoadedButNotWoven(ClassPool classPool, String classname) {
        return loadedButNotWovenClasses.containsKey(classPool) && loadedButNotWovenClasses.get(classPool).contains(classname);
    }
}

