/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.util.concurrent.Semaphore;
import org.jboss.marshalling.NioByteInput;
import org.jboss.remoting3.remote.InboundRequestInputHandler;
import org.jboss.remoting3.remote.OutboundReplyHandler;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.xnio.Cancellable;

final class InboundRequest {
    private final Semaphore flowSemaphore = new Semaphore(5);
    private Cancellable cancellable;
    private OutboundReplyHandler replyHandler;
    private final NioByteInput byteInput;
    private final RemoteConnectionHandler remoteConnectionHandler;
    private final int rid;
    private State state = State.RECEIVING;

    InboundRequest(RemoteConnectionHandler remoteConnectionHandler, int rid) {
        this.remoteConnectionHandler = remoteConnectionHandler;
        this.byteInput = new NioByteInput((NioByteInput.InputHandler)new InboundRequestInputHandler(this, rid));
        this.rid = rid;
    }

    void ack() {
        this.flowSemaphore.release();
    }

    NioByteInput getByteInput() {
        return this.byteInput;
    }

    OutboundReplyHandler getReplyHandler() {
        return this.replyHandler;
    }

    void acquire() throws InterruptedException {
        this.flowSemaphore.acquire();
    }

    void setReplyHandler(OutboundReplyHandler replyHandler) {
        this.replyHandler = replyHandler;
    }

    void setCancellable(Cancellable cancellable) {
        this.cancellable = cancellable;
    }

    public Cancellable getCancellable() {
        return this.cancellable;
    }

    RemoteConnectionHandler getRemoteConnectionHandler() {
        return this.remoteConnectionHandler;
    }

    public String toString() {
        return "Inbound request ID " + this.rid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        RECEIVING,
        RUNNING,
        SENDING,
        SENDING_EXCEPTION;

    }
}

