/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.ProtocolException;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.AbstractClientMessageHandler;
import org.jboss.remoting3.remote.ClientAuthenticationHandler;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.SaslUtils;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Result;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClientGreetingHandler
extends AbstractClientMessageHandler {
    private final RemoteConnection connection;
    private final Result<ConnectionHandlerFactory> factoryResult;
    private final CallbackHandler callbackHandler;
    private final AccessControlContext accessControlContext;
    private static final Logger log = Loggers.clientSasl;

    ClientGreetingHandler(RemoteConnection connection, Result<ConnectionHandlerFactory> factoryResult, CallbackHandler callbackHandler, AccessControlContext accessControlContext) {
        super(connection, factoryResult);
        this.connection = connection;
        this.factoryResult = factoryResult;
        this.callbackHandler = callbackHandler;
        this.accessControlContext = accessControlContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(ByteBuffer buffer) {
        final LinkedHashSet<String> saslMechs = new LinkedHashSet<String>();
        String remoteEndpointName = "endpoint";
        int[] ourVersions = this.connection.getProviderDescriptor().getSupportedVersions();
        int bestVersion = -1;
        switch (buffer.get()) {
            case 0: {
                SaslClient saslClient;
                log.trace("Client received greeting message");
                block20: while (buffer.hasRemaining()) {
                    byte type = buffer.get();
                    int len = buffer.get() & 0xFF;
                    ByteBuffer data = Buffers.slice((ByteBuffer)buffer, (int)len);
                    block8 : switch (type) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            saslMechs.add(Buffers.getModifiedUtf8((ByteBuffer)data));
                            break;
                        }
                        case 2: {
                            remoteEndpointName = Buffers.getModifiedUtf8((ByteBuffer)data);
                            break;
                        }
                        case 3: {
                            int remoteVersion = data.getInt();
                            if (remoteVersion <= bestVersion) break;
                            for (int ourVersion : ourVersions) {
                                if (ourVersion != remoteVersion) continue;
                                bestVersion = remoteVersion;
                                break block8;
                            }
                            continue block20;
                        }
                    }
                }
                if (bestVersion == -1) {
                    this.factoryResult.setException((IOException)new ProtocolException("No matching Marshalling versions could be found"));
                    IoUtils.safeClose((Closeable)this.connection);
                    return;
                }
                if (saslMechs.isEmpty()) {
                    this.factoryResult.setException((IOException)new SaslException("No more authentication mechanisms to try"));
                    IoUtils.safeClose((Closeable)this.connection);
                    return;
                }
                OptionMap optionMap = this.connection.getOptionMap();
                final String userName = (String)optionMap.get(RemotingOptions.AUTH_USER_NAME);
                final Map<String, Object> propertyMap = SaslUtils.createPropertyMap(optionMap);
                try {
                    final String finalRemoteEndpointName = remoteEndpointName;
                    saslClient = AccessController.doPrivileged(new PrivilegedExceptionAction<SaslClient>(){

                        @Override
                        public SaslClient run() throws SaslException {
                            return Sasl.createSaslClient(saslMechs.toArray(new String[saslMechs.size()]), userName, "remote", finalRemoteEndpointName, propertyMap, ClientGreetingHandler.this.callbackHandler);
                        }
                    }, this.accessControlContext);
                }
                catch (PrivilegedActionException e) {
                    SaslException se = (SaslException)e.getCause();
                    this.factoryResult.setException((IOException)se);
                    log.trace((Throwable)se, "Client connect authentication error", new Object[0]);
                    try {
                        this.remoteConnection.shutdownWritesBlocking();
                    }
                    catch (IOException e1) {
                        log.trace((Throwable)e1, "Failed to shutdown writes on %s", (Object)this.remoteConnection);
                    }
                    return;
                }
                String mechanismName = saslClient.getMechanismName();
                log.trace("Sasl mechanism selected: %s", (Object)mechanismName);
                ByteBuffer outBuf = this.connection.allocate();
                try {
                    outBuf.putInt(0);
                    outBuf.put((byte)1);
                    Buffers.putModifiedUtf8((ByteBuffer)outBuf, (String)mechanismName);
                    outBuf.flip();
                    this.connection.sendBlocking(outBuf, true);
                }
                catch (IOException e) {
                    log.trace((Throwable)e, "Failed to send auth request on %s", (Object)this.remoteConnection);
                    this.factoryResult.setException(e);
                    return;
                }
                finally {
                    this.connection.free(outBuf);
                }
                this.connection.setMessageHandler(new ClientAuthenticationHandler(this.connection, saslClient, this.factoryResult));
                return;
            }
        }
        log.warn("Received invalid greeting packet on %s", (Object)this.remoteConnection);
        try {
            this.remoteConnection.shutdownWritesBlocking();
        }
        catch (IOException e1) {
            log.trace((Throwable)e1, "Failed to shutdown writes on %s", (Object)this.remoteConnection);
        }
    }
}

