/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;

final class RequestListenerExecutor
implements Executor {
    private final Set<Task> tasks = Collections.synchronizedSet(new HashSet());
    private final Executor executor;

    public RequestListenerExecutor(Executor executor) {
        this.executor = executor;
    }

    public void execute(Runnable command) {
        this.executor.execute(new Task(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        Set<Task> set = this.tasks;
        synchronized (set) {
            Thread currentThread = Thread.currentThread();
            for (Task task : this.tasks) {
                Thread thread = task.thread;
                if (thread == null || thread == currentThread) continue;
                thread.interrupt();
            }
        }
    }

    private final class Task
    implements Runnable {
        private volatile Thread thread;
        private final Runnable runnable;

        private Task(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.thread = Thread.currentThread();
            RequestListenerExecutor.this.tasks.add(this);
            try {
                this.runnable.run();
            }
            finally {
                RequestListenerExecutor.this.tasks.remove(this);
                this.thread = null;
            }
        }
    }
}

