/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.catalina.filters.FilterBase;

public class CsrfPreventionFilter
extends FilterBase {
    private String randomClass = SecureRandom.class.getName();
    private Random randomSource;
    private final Set<String> entryPoints = new HashSet<String>();
    private int nonceCacheSize = 5;

    public void setEntryPoints(String entryPoints) {
        String[] values;
        for (String value : values = entryPoints.split(",")) {
            this.entryPoints.add(value.trim());
        }
    }

    public void setNonceCacheSize(int nonceCacheSize) {
        this.nonceCacheSize = nonceCacheSize;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        try {
            Class<?> clazz = Class.forName(this.randomClass);
            this.randomSource = (Random)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            ServletException se = new ServletException(sm.getString("csrfPrevention.invalidRandomClass", this.randomClass), (Throwable)e);
            throw se;
        }
        catch (InstantiationException e) {
            ServletException se = new ServletException(sm.getString("csrfPrevention.invalidRandomClass", this.randomClass), (Throwable)e);
            throw se;
        }
        catch (IllegalAccessException e) {
            ServletException se = new ServletException(sm.getString("csrfPrevention.invalidRandomClass", this.randomClass), (Throwable)e);
            throw se;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object wResponse = null;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            boolean skipNonceCheck = false;
            if ("GET".equals(req.getMethod())) {
                String path = req.getServletPath();
                if (req.getPathInfo() != null) {
                    path = path + req.getPathInfo();
                }
                if (this.entryPoints.contains(path)) {
                    skipNonceCheck = true;
                }
            }
            LruCache<String> nonceCache = (LruCache<String>)req.getSession(true).getAttribute("org.apache.catalina.filters.CSRF_NONCE");
            if (!skipNonceCheck) {
                String previousNonce = req.getParameter("org.apache.catalina.filters.CSRF_NONCE");
                if (nonceCache != null && !nonceCache.contains(previousNonce)) {
                    res.sendError(403);
                    return;
                }
            }
            if (nonceCache == null) {
                nonceCache = new LruCache<String>(this.nonceCacheSize);
                req.getSession().setAttribute("org.apache.catalina.filters.CSRF_NONCE", nonceCache);
            }
            String newNonce = this.generateNonce();
            nonceCache.add(newNonce);
            wResponse = new CsrfResponseWrapper(res, newNonce);
        } else {
            wResponse = response;
        }
        chain.doFilter(request, wResponse);
    }

    protected String generateNonce() {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder();
        this.randomSource.nextBytes(random);
        for (int j = 0; j < random.length; ++j) {
            byte b1 = (byte)((random[j] & 0xF0) >> 4);
            byte b2 = (byte)(random[j] & 0xF);
            if (b1 < 10) {
                buffer.append((char)(48 + b1));
            } else {
                buffer.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                buffer.append((char)(48 + b2));
                continue;
            }
            buffer.append((char)(65 + (b2 - 10)));
        }
        return buffer.toString();
    }

    private static class LruCache<T> {
        private final Map<T, T> cache;

        public LruCache(final int cacheSize) {
            this.cache = new LinkedHashMap<T, T>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<T, T> eldest) {
                    return this.size() > cacheSize;
                }
            };
        }

        public void add(T key) {
            this.cache.put(key, null);
        }

        public boolean contains(T key) {
            return this.cache.containsKey(key);
        }
    }

    private static class CsrfResponseWrapper
    extends HttpServletResponseWrapper {
        private String nonce;

        public CsrfResponseWrapper(HttpServletResponse response, String nonce) {
            super(response);
            this.nonce = nonce;
        }

        @Deprecated
        public String encodeRedirectUrl(String url) {
            return this.encodeRedirectURL(url);
        }

        public String encodeRedirectURL(String url) {
            return this.addNonce(super.encodeRedirectURL(url));
        }

        @Deprecated
        public String encodeUrl(String url) {
            return this.encodeURL(url);
        }

        public String encodeURL(String url) {
            return this.addNonce(super.encodeURL(url));
        }

        private String addNonce(String url) {
            int pound;
            if (url == null || this.nonce == null) {
                return url;
            }
            String path = url;
            String query = "";
            String anchor = "";
            int question = url.indexOf(63);
            if (question >= 0) {
                path = url.substring(0, question);
                query = url.substring(question);
            }
            if ((pound = path.indexOf(35)) >= 0) {
                anchor = path.substring(pound);
                path = path.substring(0, pound);
            }
            StringBuilder sb = new StringBuilder(path);
            sb.append(anchor);
            if (query.length() > 0) {
                sb.append(query);
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append("org.apache.catalina.filters.CSRF_NONCE");
            sb.append('=');
            sb.append(this.nonce);
            return sb.toString();
        }
    }
}

