/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.core.deployable;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import org.jboss.embedded.api.Deployable;
import org.jboss.embedded.core.deployable.DeployableFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public final class DeployableArchive
implements Deployable {
    private static final Logger log = Logger.getLogger(DeployableArchive.class.getName());
    private static final String SYS_PROP_TMP_DIR = "java.io.tmpdir";
    private final Deployable serializedView;
    private final Archive<?> createdFrom;

    public DeployableArchive(Archive<?> archive) throws IllegalArgumentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        String tempDirLocation = AccessController.doPrivileged(GetTempDirAction.INSTANCE);
        File tmpDir = new File(tempDirLocation);
        if (!tmpDir.exists()) {
            throw new IllegalStateException("Could not obtain valid temp directory: " + tmpDir.getAbsolutePath());
        }
        if (!tmpDir.isDirectory()) {
            throw new IllegalStateException("Temp location must be a directory: " + tmpDir.getAbsolutePath());
        }
        String name = archive.getName();
        File tmpFile = new File(tmpDir, name);
        tmpFile.deleteOnExit();
        ((ZipExporter)archive.as(ZipExporter.class)).exportZip(tmpFile, true);
        DeployableFile deployableFile = new DeployableFile(tmpFile);
        this.createdFrom = archive;
        this.serializedView = deployableFile;
    }

    public URL getTarget() {
        return this.serializedView.getTarget();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.createdFrom == null ? 0 : this.createdFrom.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeployableArchive other = (DeployableArchive)obj;
        if (this.createdFrom == null) {
            throw new IllegalStateException("Created from archive must never be null");
        }
        return this.createdFrom == other.createdFrom;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [archive=" + this.createdFrom.toString(true) + "]";
    }

    private static enum GetTempDirAction implements PrivilegedAction<String>
    {
        INSTANCE;


        @Override
        public String run() {
            return System.getProperty(DeployableArchive.SYS_PROP_TMP_DIR);
        }
    }
}

