/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.PackageInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.annotations.JBossXmlSchema;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
import org.jboss.xb.builder.BuilderSchemaBindingInitializer;
import org.jboss.xb.builder.JBossXBNoSchemaBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXBBuilder {
    public static final String USE_UNORDERED_SEQUENCE_PROPERTY = "xb.builder.useUnorderedSequence";
    public static final String SEQUENCES_REQUIRE_PROP_ORDER = "xb.builder.sequencesRequirePropOrder";
    public static final String ELEMENT_SET_PARENT_OVERRIDE_HANDLER = "xb.builder.elementSetParentOverrideHandler";
    public static final String REPEATABLE_PARTICLE_HANDLERS = "xb.builder.repeatableParticleHandlers";
    static Configuration configuration = (Configuration)AccessController.doPrivileged(new PrivilegedAction<PropertyConfiguration>(){

        @Override
        public PropertyConfiguration run() {
            return new PropertyConfiguration();
        }
    });
    static final ClassInfo STRING = configuration.getClassInfo(String.class);
    static final ClassInfo OBJECT = configuration.getClassInfo(Object.class);
    static boolean useUnorderedSequence = JBossXBBuilder.getBooleanProperty("xb.builder.useUnorderedSequence", false);
    static boolean sequencesRequirePropOrder = JBossXBBuilder.getBooleanProperty("xb.builder.sequencesRequirePropOrder", true);
    static boolean elementSetParentHandler = JBossXBBuilder.getBooleanProperty("xb.builder.elementSetParentOverrideHandler", true);
    static boolean repeatableParticleHandlers = JBossXBBuilder.getBooleanProperty("xb.builder.repeatableParticleHandlers", true);

    private static boolean getBooleanProperty(final String propertyName, boolean defaultValue) {
        String stringValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
        if (stringValue != null) {
            return Boolean.parseBoolean(stringValue);
        }
        return defaultValue;
    }

    public static boolean isUseUnorderedSequence() {
        return useUnorderedSequence;
    }

    public static void setUseUnorderedSequence(boolean unorderedSequences) {
        useUnorderedSequence = unorderedSequences;
    }

    public static boolean isSequencesRequirePropOrder() {
        return sequencesRequirePropOrder;
    }

    public static void setSequencesRequirePropOrder(boolean sequencesRequirePropOrder) {
        JBossXBBuilder.sequencesRequirePropOrder = sequencesRequirePropOrder;
    }

    public static boolean isElementSetParentOverrideHandler() {
        return elementSetParentHandler;
    }

    public static void setElementSetParentOverrideHandler(boolean elementSetParentHandler) {
        JBossXBBuilder.elementSetParentHandler = elementSetParentHandler;
    }

    public static boolean isRepeatableParticleHandlers() {
        return repeatableParticleHandlers;
    }

    public static void setRepeatableParticleHandlers(boolean repeatableParticleHandlers) {
        JBossXBBuilder.repeatableParticleHandlers = repeatableParticleHandlers;
    }

    public static <T> SchemaBindingInitializer newInitializer(Class<T> root) {
        return new BuilderSchemaBindingInitializer<T>(root);
    }

    public static SchemaBinding build(Class<?> ... roots) {
        return JBossXBBuilder.build(false, roots);
    }

    public static SchemaBinding build(boolean rebuildFirst, Class<?> ... roots) {
        if (roots == null || roots.length == 0) {
            throw new IllegalArgumentException("There has to be at least one root class in the arguments.");
        }
        Class<?> root = roots[0];
        if (root == null) {
            throw new IllegalArgumentException("Root class can't be null.");
        }
        SchemaBinding schema = JBossXBBuilder.build(root, rebuildFirst);
        for (int i = 1; i < roots.length; ++i) {
            root = roots[i];
            if (root == null) {
                throw new IllegalArgumentException("Root class can't be null.");
            }
            JBossXBBuilder.build(schema, root);
        }
        return schema;
    }

    public static void build(SchemaBinding schemaBinding, Class<?> root) {
        if (schemaBinding == null) {
            throw new IllegalArgumentException("Null schemaBinding");
        }
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        ClassInfo classInfo = configuration.getClassInfo(root);
        JBossXmlSchema schema = (JBossXmlSchema)classInfo.getUnderlyingAnnotation(JBossXmlSchema.class);
        PackageInfo packageInfo = classInfo.getPackage();
        if (schema == null && packageInfo != null) {
            schema = (JBossXmlSchema)packageInfo.getUnderlyingAnnotation(JBossXmlSchema.class);
        }
        String classNamespace = "";
        Set<String> schemaNamespaces = schemaBinding.getNamespaces();
        String schemaNamespace = schemaNamespaces.iterator().next();
        if (schema != null) {
            if (!"##default".equals(schema.namespace())) {
                classNamespace = schema.namespace();
            }
            if (schema.xmlns().length > 0) {
                for (int i = 0; i < schema.xmlns().length; ++i) {
                    String prefix = schema.xmlns()[i].prefix();
                    String existingMapping = schemaBinding.getNamespace(prefix);
                    if (existingMapping != null) {
                        String newMapping = schema.xmlns()[i].namespaceURI();
                        if (existingMapping.equals(newMapping)) continue;
                        throw new IllegalStateException("Class " + root.getName() + " maps prefix '" + prefix + "' to namespace '" + newMapping + "' while in the schema binding it is mapped to '" + existingMapping + "'");
                    }
                    schemaBinding.addPrefixMapping(prefix, schema.xmlns()[i].namespaceURI());
                }
            }
        }
        if (!classNamespace.equals(schemaNamespace)) {
            throw new IllegalStateException("SchemaBinding namespace '" + schemaNamespace + "' does not match class namespace '" + classNamespace + "'");
        }
        JBossXBNoSchemaBuilder builder = new JBossXBNoSchemaBuilder(classInfo);
        builder.setUseUnorderedSequence(useUnorderedSequence);
        builder.setSequencesRequirePropOrder(sequencesRequirePropOrder);
        builder.setElementSetParentOverrideHandler(elementSetParentHandler);
        builder.setRepeatableParticleHandlers(repeatableParticleHandlers);
        builder.build(schemaBinding);
    }

    public static SchemaBinding build(Class<?> root) {
        return JBossXBBuilder.build(root, false);
    }

    public static SchemaBinding build(Class<?> root, boolean rebuild) {
        ClassInfo classInfo = configuration.getClassInfo(root);
        SchemaBinding binding = (SchemaBinding)classInfo.getAttachment(SchemaBinding.class);
        if (rebuild || binding == null) {
            JBossXBNoSchemaBuilder builder = new JBossXBNoSchemaBuilder(classInfo);
            builder.setUseUnorderedSequence(useUnorderedSequence);
            builder.setSequencesRequirePropOrder(sequencesRequirePropOrder);
            builder.setElementSetParentOverrideHandler(elementSetParentHandler);
            builder.setRepeatableParticleHandlers(repeatableParticleHandlers);
            binding = builder.build();
            classInfo.setAttachment(SchemaBinding.class.getName(), (Object)binding);
        }
        return binding;
    }

    protected static void initSchema(SchemaBinding schemaBinding, ClassInfo classInfo) {
        JBossXmlSchema schema = (JBossXmlSchema)classInfo.getUnderlyingAnnotation(JBossXmlSchema.class);
        PackageInfo packageInfo = classInfo.getPackage();
        if (schema == null && packageInfo != null) {
            schema = (JBossXmlSchema)packageInfo.getUnderlyingAnnotation(JBossXmlSchema.class);
        }
        String packageName = null;
        if (packageInfo != null) {
            packageName = packageInfo.getName();
        }
        if (schema != null) {
            String schemaPackageName = schema.packageName();
            if (!"##default".equals(schemaPackageName)) {
                packageName = schemaPackageName;
            }
            if (schema.xmlns().length > 0) {
                for (int i = 0; i < schema.xmlns().length; ++i) {
                    schemaBinding.addPrefixMapping(schema.xmlns()[i].prefix(), schema.xmlns()[i].namespaceURI());
                }
            }
        }
        if (schemaBinding.getNamespaces().isEmpty()) {
            String schemaNamespace;
            String namespace = "";
            if (schema != null && !"##default".equals(schemaNamespace = schema.namespace())) {
                namespace = schemaNamespace;
            }
            schemaBinding.setNamespaces(new HashSet<String>(Collections.singleton(namespace)));
        }
        if (packageName != null) {
            PackageMetaData packageMetaData = new PackageMetaData();
            packageMetaData.setName(packageName);
            schemaBinding.setPackageMetaData(packageMetaData);
        }
        if (schema == null) {
            return;
        }
        schemaBinding.setIgnoreUnresolvedFieldOrClass(schema.ignoreUnresolvedFieldOrClass());
        schemaBinding.setIgnoreLowLine(schema.ignoreLowLine());
        schemaBinding.setReplacePropertyRefs(schema.replacePropertyRefs());
        schemaBinding.setStrictSchema(schema.strict());
        schemaBinding.setNormalizeSpace(schema.normalizeSpace());
    }

    public static String generateXMLNameFromClassName(TypeInfo typeInfo, boolean ignoreLowerLine) {
        return JBossXBBuilder.generateXMLNameFromJavaName(typeInfo.getSimpleName(), true, ignoreLowerLine);
    }

    public static String generateXMLNameFromJavaName(String string, boolean dash, boolean ignoreLowerLine) {
        boolean seenLower = false;
        boolean first = true;
        StringBuilder result = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (first || !seenLower && Character.isUpperCase(c)) {
                result.append(Character.toLowerCase(c));
                first = false;
                continue;
            }
            if (seenLower && Character.isUpperCase(c) && dash) {
                result.append('-');
                result.append(Character.toLowerCase(c));
                seenLower = false;
                continue;
            }
            result.append(c);
            seenLower = true;
        }
        return result.toString();
    }
}

