/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.StompFrameDecoder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class WebSocketStompFrameEncoder
extends OneToOneEncoder {
    private final StompFrameDecoder decoder = new StompFrameDecoder();

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        ChannelBufferWrapper buffer;
        StompFrame frame;
        if (msg instanceof ChannelBuffer && (frame = this.decoder.decode(buffer = new ChannelBufferWrapper((ChannelBuffer)msg))) != null) {
            DefaultWebSocketFrame wsFrame = new DefaultWebSocketFrame(frame.asString());
            ChannelBuffer data = wsFrame.getBinaryData();
            ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data.order(), data.readableBytes() + 2);
            encoded.writeByte((int)((byte)wsFrame.getType()));
            encoded.writeBytes(data, data.readableBytes());
            encoded.writeByte(-1);
            return encoded;
        }
        return msg;
    }
}

