/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import org.jboss.deployers.spi.management.ManagedComponentRuntimeDispatcher;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.plugins.values.MetaValueFactoryBuilder;
import org.jboss.metatype.spi.values.MetaMapper;

public abstract class AbstractManagedComponentRuntimeDispatcher
implements ManagedComponentRuntimeDispatcher {
    private static final MetaValueFactory valueFactory = MetaValueFactoryBuilder.create();

    protected abstract Object get(Object var1, String var2) throws Throwable;

    protected abstract void set(Object var1, String var2, Object var3) throws Throwable;

    protected abstract Object invoke(Object var1, String var2, Object[] var3, String[] var4) throws Throwable;

    public MetaValue get(Object componentName, ManagedProperty property) {
        Object value = null;
        try {
            value = this.get(componentName, property.getName());
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Failed to get property '" + property.getName() + "' on component '" + componentName + "'.");
        }
        MetaMapper mapper = (MetaMapper)property.getTransientAttachment(MetaMapper.class);
        return this.create(value, property.getMetaType(), mapper);
    }

    public void set(Object componentName, ManagedProperty property, MetaValue metaValue) {
        MetaMapper mapper = (MetaMapper)property.getTransientAttachment(MetaMapper.class);
        Object value = this.unwrap(metaValue, mapper);
        try {
            this.set(componentName, property.getName(), value);
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Failed to set property '" + property.getName() + "' on component '" + componentName + "' to value [" + value + "].");
        }
    }

    public MetaValue invoke(Object componentName, ManagedOperation operation, MetaValue ... param) {
        String[] sig = new String[param.length];
        Object[] args = new Object[param.length];
        ManagedParameter[] params = operation.getParameters();
        for (int i = 0; i < param.length; ++i) {
            ManagedParameter mp = params[i];
            MetaMapper mapper = (MetaMapper)mp.getTransientAttachment(MetaMapper.class);
            args[i] = this.unwrap(param[i], mapper);
            sig[i] = mp.getMetaType().getTypeName();
        }
        try {
            Object value = this.invoke(componentName, operation.getName(), args, sig);
            MetaValue mvalue = null;
            if (value != null) {
                MetaType type = operation.getReturnType();
                MetaMapper returnTypeMapper = (MetaMapper)operation.getTransientAttachment(MetaMapper.class);
                mvalue = this.create(value, type, returnTypeMapper);
            }
            return mvalue;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Failed to invoke method '" + operation.getName() + "' on component '" + componentName + "' with parameters " + Arrays.asList(param) + ".");
        }
    }

    protected <T> MetaValue create(T value, MetaType metaType, MetaMapper<T> mapper) {
        if (mapper != null) {
            return mapper.createMetaValue(metaType, value);
        }
        return this.create(value);
    }

    protected MetaValue create(Object value) {
        return valueFactory.create(value);
    }

    protected <T> Object unwrap(MetaValue metaValue, MetaMapper<T> metaMapper) {
        if (metaMapper != null) {
            return metaMapper.unwrapMetaValue(metaValue);
        }
        return this.unwrap(metaValue);
    }

    protected Object unwrap(MetaValue metaValue) {
        return valueFactory.unwrap(metaValue);
    }
}

