/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact.maven;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.profileservice.repository.artifact.maven.MavenArtifactId;
import org.jboss.profileservice.repository.artifact.maven.MavenArtifactMetaData;

public class MavenArtifactReference
implements MavenArtifactId {
    private static final long serialVersionUID = -9012276056014129322L;
    public static final String DEFAULT_PACKAGING = "jar";
    private String groupId;
    private String artifactId;
    private String classifier;
    private String packagingType;

    public MavenArtifactReference() {
        this.packagingType = DEFAULT_PACKAGING;
    }

    public MavenArtifactReference(String groupId, String artifactId) {
        this(groupId, artifactId, DEFAULT_PACKAGING);
    }

    public MavenArtifactReference(String groupId, String artifactId, String packaging) {
        if (groupId == null) {
            throw new IllegalArgumentException("null group id");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("null artifact id");
        }
        if (packaging == null) {
            throw new IllegalArgumentException("null packaging");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packagingType = packaging;
    }

    @XmlTransient
    public String getType() {
        return MavenArtifactMetaData.TYPE;
    }

    @Override
    @XmlAttribute(name="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    @XmlAttribute(name="artifactId")
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    @XmlAttribute(name="classifier")
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Override
    @XmlAttribute(name="packaging")
    public String getPackagingType() {
        return this.packagingType;
    }

    public void setPackagingType(String packaging) {
        this.packagingType = packaging;
    }

    public int hashCode() {
        int result = 17;
        if (this.groupId != null) {
            result = 31 * result + this.groupId.hashCode();
        }
        if (this.artifactId != null) {
            result = 31 * result + this.artifactId.hashCode();
        }
        if (this.classifier != null) {
            result = 31 * result + this.classifier.hashCode();
        }
        if (this.packagingType != null) {
            result = 31 * result + this.packagingType.hashCode();
        }
        result = 31 * result + super.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof MavenArtifactReference)) {
            return false;
        }
        MavenArtifactReference other = (MavenArtifactReference)obj;
        if (!this.artifactEquals(other)) {
            return false;
        }
        return super.equals(other);
    }

    protected boolean artifactEquals(MavenArtifactId other) {
        if (!MavenArtifactReference.equals(this.getGroupId(), other.getGroupId())) {
            return false;
        }
        if (!MavenArtifactReference.equals(this.getArtifactId(), other.getArtifactId())) {
            return false;
        }
        if (!MavenArtifactReference.equals(this.getClassifier(), other.getClassifier())) {
            return false;
        }
        return MavenArtifactReference.equals(this.getPackagingType(), other.getPackagingType());
    }

    protected static boolean equals(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null && two != null) {
            return false;
        }
        return one.equals(two);
    }

    @Override
    public boolean matches(MavenArtifactId artifact) {
        if (artifact == null || !(artifact instanceof MavenArtifactMetaData)) {
            return false;
        }
        MavenArtifactMetaData other = (MavenArtifactMetaData)artifact;
        return this.artifactEquals(other);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        this.toString(buffer);
        buffer.append("}");
        return buffer.toString();
    }

    protected void toString(StringBuffer buffer) {
        buffer.append("group=").append(this.getGroupId());
        buffer.append(", artifact=").append(this.getArtifactId());
        if (this.getClassifier() != null) {
            buffer.append(", classifier=").append(this.getClassifier());
        }
        if (this.getPackagingType() != null) {
            buffer.append(", packaging=").append(this.getPackagingType());
        }
    }
}

