/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile.bootstrap;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.BasicKernelDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
import org.jboss.metadata.spi.MetaData;
import org.jboss.profileservice.deployment.DeploymentBuilder;
import org.jboss.profileservice.deployment.ProfileDeployerPlugin;
import org.jboss.profileservice.profile.bootstrap.KernelDeploymentBuilder;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;

public class BootstrapDeployerPlugin
implements ProfileDeployerPlugin {
    private static final ManagedObjectFactory managedObjectFactory = ManagedObjectFactoryBuilder.create();
    private final Kernel kernel;
    private final BasicKernelDeployer deployer;
    private volatile boolean shutdown = false;
    private DeploymentBuilder<KernelDeployment> deploymentBuilder = new KernelDeploymentBuilder();
    private final Map<String, KernelDeployment> deployments = new ConcurrentHashMap<String, KernelDeployment>();

    public BootstrapDeployerPlugin(Kernel kernel) {
        if (kernel == null) {
            throw new IllegalArgumentException("null kernel");
        }
        this.kernel = kernel;
        this.deployer = new BasicKernelDeployer(kernel);
    }

    public DeploymentBuilder<KernelDeployment> getDeploymentBuilder() {
        return this.deploymentBuilder;
    }

    public void setDeploymentBuilder(DeploymentBuilder<KernelDeployment> deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    @Override
    public void addDeployment(ProfileKey key, ProfileDeployment deployment) throws Exception {
        this.checkShutdown();
        try {
            if (!deployment.getRoot().exists()) {
                throw new FileNotFoundException(deployment.getRoot().getPathName());
            }
            KernelDeployment result = this.createKernelDeployment(key, deployment);
            this.deployments.put(deployment.getName(), result);
            this.deployer.deploy(result);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("failed to deploy " + deployment, t);
        }
    }

    @Override
    public void checkComplete(String ... names) throws Exception {
        if (names != null && names.length > 0) {
            for (String name : names) {
                KernelDeployment deployment = this.deployments.get(name);
                if (deployment == null) {
                    return;
                }
                try {
                    this.deployer.validate(deployment);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException("failed to deploy " + deployment, t);
                }
            }
        }
    }

    @Override
    public void checkComplete() throws Exception {
        try {
            for (KernelDeployment deployment : this.deployments.values()) {
                this.deployer.validate(deployment);
            }
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void process() {
    }

    @Override
    public void removeDeployment(ProfileKey key, ProfileDeployment deployment) throws Exception {
        if (deployment == null) {
            throw new IllegalArgumentException("null deployment");
        }
        KernelDeployment kernelDeployment = this.deployments.remove(deployment.getName());
        if (kernelDeployment != null) {
            this.deployer.undeploy(kernelDeployment);
        }
    }

    @Override
    public boolean isSupportRedeployment() {
        return false;
    }

    @Override
    public ManagedDeployment getManagedDeployment(ProfileDeployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("null deployment");
        }
        KernelDeployment result = this.deployments.get(deployment.getName());
        if (result == null) {
            throw new IllegalStateException("no deployment registered with name " + deployment.getName());
        }
        return this.createManagedDeployment(result);
    }

    @Override
    public void prepareShutdown() {
        this.shutdown = true;
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
        }
        if (this.deployments.size() > 0) {
            for (KernelDeployment deployment : this.deployments.values()) {
                this.deployer.undeploy(deployment);
            }
        }
    }

    protected void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("deployer is shutdown");
        }
    }

    protected KernelDeployment createKernelDeployment(ProfileKey key, ProfileDeployment profileDeployment) throws Exception {
        return this.deploymentBuilder.createDeployment(key, profileDeployment);
    }

    protected ManagedDeployment createManagedDeployment(KernelDeployment kernelDeployment) {
        HashMap<String, ManagedObject> managedObjects = new HashMap<String, ManagedObject>();
        List beanFactories = kernelDeployment.getBeanFactories();
        if (beanFactories != null && !beanFactories.isEmpty()) {
            for (BeanMetaDataFactory beanFactory : beanFactories) {
                List beans = beanFactory.getBeans();
                if (beans == null || beans.isEmpty()) continue;
                for (BeanMetaData bmd : beans) {
                    String name = bmd.getName();
                    ControllerContext context = this.getKernelController().getContext((Object)bmd.getName(), null);
                    MetaData metaData = this.getMetaDataRepository().getMetaData(context);
                    ManagedObject mo = managedObjectFactory.initManagedObject((Object)bmd, null, metaData, name, null);
                    if (mo == null) continue;
                    managedObjects.put(name, mo);
                }
            }
        }
        return new ManagedDeploymentImpl(kernelDeployment.getName(), kernelDeployment.getName(), null, managedObjects);
    }

    KernelController getKernelController() {
        return this.kernel.getController();
    }

    KernelMetaDataRepository getMetaDataRepository() {
        return this.kernel.getMetaDataRepository();
    }
}

