/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.jboss.profileservice.config.ProfileServiceConfig;
import org.jboss.profileservice.deployment.hotdeploy.ProfileDeploymentModificationChecker;
import org.jboss.profileservice.profile.AbstractScanningProfile;
import org.jboss.profileservice.profile.HDScanningProfile;
import org.jboss.profileservice.profile.MutableScanningProfile;
import org.jboss.profileservice.profile.metadata.plugin.HotDeploymentProfileMetaData;
import org.jboss.profileservice.profile.metadata.plugin.PropertyProfileMetaData;
import org.jboss.profileservice.profile.metadata.plugin.PropertyProfileSourceMetaData;
import org.jboss.profileservice.repository.artifact.AbstractRepositoryId;
import org.jboss.profileservice.repository.artifact.ArtifactRepositoryManager;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.repository.artifact.file.FileRepositoryConfiguration;
import org.jboss.profileservice.repository.virtual.DelegatingDeploymentRepository;
import org.jboss.profileservice.spi.ProfileFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;

public class ScanningProfileFactory
implements ProfileFactory<PropertyProfileMetaData, AbstractScanningProfile> {
    private static final String[] types = new String[]{PropertyProfileMetaData.class.getName(), HotDeploymentProfileMetaData.class.getName()};
    private final ProfileServiceConfig config;
    private ArtifactRepositoryManager repositoryManager;
    private ProfileDeploymentModificationChecker modificationChecker;

    public ScanningProfileFactory(ProfileServiceConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("null profile service config");
        }
        this.config = config;
    }

    public String[] getTypes() {
        return types;
    }

    public ArtifactRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setRepositoryManager(ArtifactRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public ProfileDeploymentModificationChecker getModificationChecker() {
        return this.modificationChecker;
    }

    public void setModificationChecker(ProfileDeploymentModificationChecker modificationChecker) {
        this.modificationChecker = modificationChecker;
    }

    public AbstractScanningProfile createProfile(ProfileKey key, PropertyProfileMetaData metaData) throws Exception {
        PropertyProfileSourceMetaData source = metaData.getSource();
        VirtualDeploymentRepository repository = this.createDeploymentRepository(Integer.toString(key.hashCode()), source, true);
        if (metaData.isHotDeploymentEnabled()) {
            HDScanningProfile mutable = new HDScanningProfile(key, repository);
            mutable.setModificationChecker(this.modificationChecker);
            return mutable;
        }
        return new MutableScanningProfile(key, repository);
    }

    public void destroyProfile(PropertyProfileMetaData metaData, AbstractScanningProfile profile) {
        this.cleanupRepository(profile.getDeploymentRepository());
    }

    protected VirtualDeploymentRepository createDeploymentRepository(String artifactRepoName, PropertyProfileSourceMetaData source, boolean isMutable) throws IOException, URISyntaxException {
        ArtifactRepository<ArtifactId> fileRepository = this.repositoryManager.createArtifactRepository(this.createFileRepositoryId(artifactRepoName), this.createRepositoryConfiguration(source, isMutable));
        return new DelegatingDeploymentRepository(this.getRepositoryManager(), this.config.getAssemblyConfiguration(), (ArtifactRepositoryId)fileRepository.getIdentifier());
    }

    protected void cleanupRepository(VirtualDeploymentRepository repository) {
        Collection repositories = repository.getRepositoryIDs();
        if (repositories != null && !repositories.isEmpty()) {
            for (ArtifactRepositoryId artifactRepository : repositories) {
                this.repositoryManager.removeRepository(artifactRepository);
            }
        }
    }

    protected AbstractRepositoryId createFileRepositoryId(String group) {
        return new AbstractRepositoryId(group, FileArtifactId.TYPE);
    }

    protected ArtifactRepositoryConfiguration<ArtifactId> createRepositoryConfiguration(PropertyProfileSourceMetaData source, boolean mutable) throws URISyntaxException {
        FileRepositoryConfiguration configuration = new FileRepositoryConfiguration();
        configuration.setOverrideURI(new URI(source.getPath()));
        configuration.setMutable(mutable);
        configuration.setCreateIfDoesNotExists(source.isCreateIfDoesNotExist());
        if (mutable) {
            configuration.setBackupPolicy(ArtifactRepositoryConfiguration.VFSBackupPolicy.BACKUP);
        }
        return (ArtifactRepositoryConfiguration)ArtifactRepositoryConfiguration.class.cast(configuration);
    }
}

