/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Map;
import java.util.Properties;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LegacyKeySupportTypedProperties
extends TypedProperties {
    private final Map<String, String> legacyKeyMapping;
    private static final Log log = LogFactory.getLog(LegacyKeySupportTypedProperties.class);

    public LegacyKeySupportTypedProperties(Properties p, Map<String, String> legacyKeyMapping) {
        super(p);
        this.legacyKeyMapping = legacyKeyMapping;
    }

    public LegacyKeySupportTypedProperties(Map<String, String> legacyKeyMapping) {
        this.legacyKeyMapping = legacyKeyMapping;
    }

    private void warnLegacy(String oldKey, String newKey) {
        if (log.isInfoEnabled()) {
            log.info((Object)"Could not find value for key {0}, but did find value under deprecated key {1}. Please use {0} as support for {1} will eventually be discontinued.", newKey, oldKey);
        }
    }

    @Override
    public String getProperty(String key) {
        if (this.containsKey(key)) {
            return super.getProperty(key);
        }
        String legacyKey = this.legacyKeyMapping.get(key);
        if (legacyKey == null) {
            return null;
        }
        String val = super.getProperty(legacyKey);
        if (val != null) {
            this.warnLegacy(legacyKey, key);
        }
        return val;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.containsKey(key)) {
            return super.getProperty(key);
        }
        String legacyKey = this.legacyKeyMapping.get(key);
        if (legacyKey == null) {
            return defaultValue;
        }
        String val = super.getProperty(legacyKey);
        if (val != null) {
            this.warnLegacy(legacyKey, key);
            return val;
        }
        return defaultValue;
    }

    @Override
    public int getIntProperty(String key, int defaultValue) {
        if (this.containsKey(key)) {
            return super.getIntProperty(key, defaultValue);
        }
        String legacyKey = this.legacyKeyMapping.get(key);
        if (legacyKey == null) {
            return defaultValue;
        }
        if (this.containsKey(legacyKey)) {
            this.warnLegacy(legacyKey, key);
            return super.getIntProperty(legacyKey, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public long getLongProperty(String key, long defaultValue) {
        if (this.containsKey(key)) {
            return super.getLongProperty(key, defaultValue);
        }
        String legacyKey = this.legacyKeyMapping.get(key);
        if (legacyKey == null) {
            return defaultValue;
        }
        if (this.containsKey(legacyKey)) {
            this.warnLegacy(legacyKey, key);
            return super.getLongProperty(legacyKey, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean getBooleanProperty(String key, boolean defaultValue) {
        if (this.containsKey(key)) {
            return super.getBooleanProperty(key, defaultValue);
        }
        String legacyKey = this.legacyKeyMapping.get(key);
        if (legacyKey == null) {
            return defaultValue;
        }
        if (this.containsKey(legacyKey)) {
            this.warnLegacy(legacyKey, key);
            return super.getBooleanProperty(legacyKey, defaultValue);
        }
        return defaultValue;
    }
}

