/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.InvocationContext;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.PerVmAdvice;
import org.jboss.aspects.currentinvocation.CurrentInvocationInterceptor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisorHelper;
import org.jboss.ejb3.interceptors.aop.InvocationContextInterceptor;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbackBeanMethodInterceptor;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbackInterceptorMethodInterceptor;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbackInterceptorMethodLazyInterceptor;
import org.jboss.ejb3.interceptors.container.BeanContext;
import org.jboss.ejb3.interceptors.lang.ClassHelper;
import org.jboss.logging.Logger;

public class LifecycleCallbacks {
    private static final Logger log = Logger.getLogger(LifecycleCallbacks.class);

    @Deprecated
    public static Interceptor[] createLifecycleCallbackInterceptors(Advisor advisor, List<Class<?>> lifecycleInterceptorClasses, BeanContext<?> component, Class<? extends Annotation> lifecycleAnnotationType) throws Exception {
        ArrayList<Object> interceptors = new ArrayList<Object>();
        AdviceStack stack = advisor.getManager().getAdviceStack("LifecycleCallbackStack");
        if (stack == null) {
            log.warn((Object)("EJBTHREE-1480: LifecycleCallbackStack has not been defined for " + LifecycleCallbacks.toString(advisor.getManager())));
            interceptors.add(new CurrentInvocationInterceptor());
            interceptors.add(PerVmAdvice.generateInterceptor(null, (Object)new InvocationContextInterceptor(), (String)"setup"));
        } else {
            interceptors.addAll(Arrays.asList(stack.createInterceptors(advisor, null)));
        }
        for (Class<?> interceptorClass : lifecycleInterceptorClasses) {
            Object interceptor = component.getInterceptor(interceptorClass);
            ExtendedAdvisor interceptorAdvisor = ExtendedAdvisorHelper.getExtendedAdvisor(advisor, interceptor);
            HashSet<Class<?>> classes = null;
            for (Method interceptorMethod : ClassHelper.getAllMethods(interceptorClass)) {
                if (ClassHelper.isOverridden(interceptorClass, interceptorMethod) || !interceptorAdvisor.isAnnotationPresent(interceptorClass, interceptorMethod, lifecycleAnnotationType)) continue;
                classes = LifecycleCallbacks.checkClass(classes, interceptorMethod, advisor, lifecycleAnnotationType);
                interceptors.add(new LifecycleCallbackInterceptorMethodInterceptor(interceptor, interceptorMethod));
            }
        }
        Class beanClass = advisor.getClazz();
        HashSet<Class<?>> classes = null;
        for (Method beanMethod : ClassHelper.getAllMethods(beanClass)) {
            if (ClassHelper.isOverridden(beanClass, beanMethod) || !advisor.hasAnnotation(beanMethod, lifecycleAnnotationType)) continue;
            classes = LifecycleCallbacks.checkClass(classes, beanMethod, advisor, lifecycleAnnotationType);
            interceptors.add(new LifecycleCallbackBeanMethodInterceptor(beanMethod));
        }
        return interceptors.toArray(new Interceptor[0]);
    }

    private static HashSet<Class<?>> checkClass(HashSet<Class<?>> classes, Method m, Advisor advisor, Class<? extends Annotation> lifecycleAnnotationType) {
        if (classes != null) {
            if (classes.contains(m.getDeclaringClass())) {
                String type = null;
                if (lifecycleAnnotationType == PostConstruct.class) {
                    type = "post-construct";
                } else if (lifecycleAnnotationType == PreDestroy.class) {
                    type = "pre-destroy";
                } else if (lifecycleAnnotationType == PostActivate.class) {
                    type = "post-activate";
                } else if (lifecycleAnnotationType == PrePassivate.class) {
                    type = "pre-passivate";
                }
                throw new RuntimeException("More than one '" + type + "' method in " + advisor.getName());
            }
        } else {
            classes = new HashSet();
        }
        classes.add(m.getDeclaringClass());
        return classes;
    }

    private static String toString(AspectManager manager) {
        if (manager instanceof Domain) {
            return "domain '" + ((Domain)manager).getDomainName() + "'";
        }
        return manager.toString();
    }

    public static Interceptor[] createLifecycleCallbackInterceptors(Advisor advisor, List<Class<?>> lifecycleInterceptorClasses, Class<? extends Annotation> lifecycleAnnotationType) {
        Method[] possibleLifecycleMethods;
        ArrayList<Object> interceptors = new ArrayList<Object>();
        AdviceStack stack = advisor.getManager().getAdviceStack("LifecycleCallbackStack");
        if (stack == null) {
            Interceptor invocationContextInterceptor;
            log.warn((Object)("EJBTHREE-1480: LifecycleCallbackStack has not been defined for " + LifecycleCallbacks.toString(advisor.getManager())));
            interceptors.add(new CurrentInvocationInterceptor());
            try {
                invocationContextInterceptor = PerVmAdvice.generateInterceptor(null, (Object)new InvocationContextInterceptor(), (String)"setup");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate invocation context interceptor", e);
            }
            interceptors.add(invocationContextInterceptor);
        } else {
            interceptors.addAll(Arrays.asList(stack.createInterceptors(advisor, null)));
        }
        for (Class<?> interceptorClass : lifecycleInterceptorClasses) {
            Method[] possibleLifecycleInterceptorMethods;
            ExtendedAdvisor interceptorAdvisor = ExtendedAdvisorHelper.getExtendedAdvisor(advisor);
            HashSet<Class<?>> classes = null;
            for (Method interceptorMethod : possibleLifecycleInterceptorMethods = ClassHelper.getMethods(interceptorClass, Void.TYPE, InvocationContext.class)) {
                if (!interceptorAdvisor.isAnnotationPresent(interceptorClass, interceptorMethod, lifecycleAnnotationType) || ClassHelper.isOverridden(interceptorClass, interceptorMethod)) continue;
                classes = LifecycleCallbacks.checkClass(classes, interceptorMethod, advisor, lifecycleAnnotationType);
                interceptors.add(new LifecycleCallbackInterceptorMethodLazyInterceptor(interceptorClass, interceptorMethod));
            }
        }
        Class beanClass = advisor.getClazz();
        HashSet<Class<?>> classes = null;
        for (Method beanMethod : possibleLifecycleMethods = ClassHelper.getMethods(beanClass, Void.TYPE, new Class[0])) {
            if (!advisor.hasAnnotation(beanMethod, lifecycleAnnotationType) || ClassHelper.isOverridden(beanClass, beanMethod)) continue;
            classes = LifecycleCallbacks.checkClass(classes, beanMethod, advisor, lifecycleAnnotationType);
            interceptors.add(new LifecycleCallbackBeanMethodInterceptor(beanMethod));
        }
        return interceptors.toArray(new Interceptor[0]);
    }
}

