/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.plugins.loader;

import java.lang.annotation.Annotation;
import org.jboss.metadata.plugins.loader.BasicMetaDataLoader;
import org.jboss.metadata.spi.Restricted;
import org.jboss.metadata.spi.loader.MutableMetaDataLoader;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableMetaDataLoader
extends BasicMetaDataLoader
implements MutableMetaDataLoader {
    private final boolean restricted;

    public AbstractMutableMetaDataLoader() {
        this(false);
    }

    public AbstractMutableMetaDataLoader(boolean restricted) {
        this.restricted = restricted;
    }

    public AbstractMutableMetaDataLoader(ScopeKey key) {
        this(key, false);
    }

    public AbstractMutableMetaDataLoader(ScopeKey key, boolean restricted) {
        super(key);
        this.restricted = restricted;
    }

    public void checkRestricted(Annotation annotation) {
        Class<? extends Annotation> annotationType;
        if (this.restricted && (annotationType = annotation.annotationType()).isAnnotationPresent(Restricted.class)) {
            throw new SecurityException("Context is restricted, not allowed to add " + annotationType.getName());
        }
    }

    public void checkRestricted(Class<?> type) {
        if (this.restricted && type.isAnnotationPresent(Restricted.class)) {
            throw new SecurityException("Context is restricted, not allowed to add " + type.getName());
        }
    }

    @Override
    public <T> T addMetaData(T metaData, Class<T> type) {
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (!type.isAnnotation()) {
            throw new IllegalArgumentException("Only annotation types are supported: " + type.getClass().getName());
        }
        Annotation annotation = (Annotation)metaData;
        return (T)this.addAnnotation(annotation);
    }

    @Override
    public <T> T removeMetaData(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (!type.isAnnotation()) {
            throw new IllegalArgumentException("Only annotation types are supported: " + type.getName());
        }
        return this.removeAnnotation(type);
    }

    @Override
    public <T> T addMetaData(String name, T metaData, Class<T> type) {
        return this.addMetaData(metaData, type);
    }

    @Override
    public <T> T removeMetaData(String name, Class<T> type) {
        return this.removeMetaData(type);
    }
}

