/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.tools;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.system.tools.DeploymentRepositoryAdapter;
import org.jboss.system.tools.DeploymentScannerMBean;
import org.jboss.util.StringPropertyReplacer;

@JMX(name="jboss.deployment:flavor=URL,type=DeploymentScanner", exposedInterface=DeploymentScannerMBean.class, registerDirectly=true)
public class DeploymentScanner
implements DeploymentScannerMBean {
    private JBossASServerConfig serverConfig;
    private URL serverHomeURL;
    private DeploymentRepositoryAdapter adapter;

    public DeploymentScanner(DeploymentRepositoryAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Null adapter");
        }
        this.adapter = adapter;
    }

    public void create() {
        if (this.serverConfig == null) {
            throw new IllegalArgumentException("Null server config.");
        }
        this.serverHomeURL = this.serverConfig.getServerHomeLocation();
    }

    @Start(ignored=true)
    public void start() {
        this.adapter.resume();
    }

    @Stop(ignored=true)
    public void stop() {
        this.adapter.suspend();
    }

    public void addURL(String url) throws MalformedURLException, URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        this.addURL(this.makeURL(url));
    }

    public void addURL(URL url) throws URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        this.adapter.addURL(url);
    }

    public void removeURL(String url) throws MalformedURLException, URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        this.removeURL(this.makeURL(url));
    }

    public void removeURL(URL url) throws URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        this.adapter.removeURL(url);
    }

    public boolean hasURL(String url) throws MalformedURLException, URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        return this.hasURL(this.makeURL(url));
    }

    public boolean hasURL(URL url) throws URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        return this.adapter.hasURL(url);
    }

    public String[] listDeployedURLs() {
        return this.adapter.listDeployedURLs();
    }

    protected URL makeURL(String urlspec) throws MalformedURLException {
        urlspec = StringPropertyReplacer.replaceProperties((String)urlspec);
        return new URL(this.serverHomeURL, urlspec);
    }

    public void setServerConfig(JBossASServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }
}

