/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.util.Arrays;
import javassist.CtBehavior;
import javassist.CtConstructor;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.javassist.JavassistAccessController;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistConstructor;
import org.jboss.reflect.plugins.javassist.JavassistReflectionFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.SignatureKey;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MutableConstructorInfo;
import org.jboss.util.JBossStringBuilder;

public class JavassistConstructorInfo
extends JavassistAnnotatedParameterInfo
implements MutableConstructorInfo {
    private static final long serialVersionUID = -2255405601790592604L;
    private volatile transient JavassistConstructor constructor;

    public JavassistConstructorInfo(SignatureKey signatureKey, AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtConstructor ctConstructor) {
        super(signatureKey, annotationHelper, typeInfo, (CtBehavior)ctConstructor);
    }

    public Object newInstance(Object[] args) throws Throwable {
        if (this.constructor == null) {
            JavassistConstructor ctor = JavassistReflectionFactory.INSTANCE.createConstructor(this);
            if (this.constructor == null) {
                this.constructor = ctor;
            }
        }
        JavassistAccessController.checkAccess(this);
        return this.constructor.newInstance(args);
    }

    protected int getHashCode() {
        int result = this.getDeclaringClass().hashCode();
        if (this.parameters == null) {
            this.generateParameters();
        }
        if (this.parameterTypes != null) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                result = 29 * result + this.parameterTypes[i].hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ConstructorInfo)) {
            return false;
        }
        ConstructorInfo other = (ConstructorInfo)obj;
        if (!((JavassistTypeInfo)this.getDeclaringClass()).equals(other.getDeclaringClass())) {
            return false;
        }
        if (other instanceof JavassistConstructorInfo) {
            return this.getSignatureKey().equals(((JavassistConstructorInfo)other).getSignatureKey());
        }
        return Arrays.equals(this.getParameterTypes(), other.getParameterTypes());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append(Arrays.asList(this.getParameterTypes()));
        super.toString(buffer);
    }

    protected CtConstructor getCtConstructor() {
        return (CtConstructor)this.ctBehavior;
    }

    public String getName() {
        return "<init>";
    }
}

