/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityActions {
    static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return GetClassLoaderAction.NON_PRIVILEGED.getClassLoader(clazz);
        }
        return GetClassLoaderAction.PRIVILEGED.getClassLoader(clazz);
    }

    static ClassLoader getClassLoaderOrSystemClassLoader(Class<?> clazz) {
        ClassLoader loader = SecurityActions.getClassLoader(clazz);
        if (loader != null) {
            return loader;
        }
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(GetSystemClassLoaderAction.INSTANCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetSystemClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private static final GetSystemClassLoaderAction INSTANCE = new GetSystemClassLoaderAction();

        GetSystemClassLoaderAction() {
        }

        @Override
        public ClassLoader run() {
            return ClassLoader.getSystemClassLoader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetClassLoaderAction {
        public static final GetClassLoaderAction NON_PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(Class<?> clazz) {
                return clazz.getClassLoader();
            }
        };
        public static final GetClassLoaderAction PRIVILEGED = new GetClassLoaderAction(){

            @Override
            public ClassLoader getClassLoader(final Class<?> clazz) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return clazz.getClassLoader();
                    }
                });
            }
        };

        public ClassLoader getClassLoader(Class<?> var1);
    }
}

