/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.reflect.plugins.bytecode.ClassLoaderFinder;
import org.jboss.reflect.plugins.bytecode.SecurityActions;

public class CachingLoadClassClassLoaderFinder
implements ClassLoaderFinder {
    public static CachingLoadClassClassLoaderFinder INSTANCE = new CachingLoadClassClassLoaderFinder();
    private final ConcurrentMap<ClassLoader, ConcurrentMap<String, ClassLoader>> loaders = new ConcurrentHashMap<ClassLoader, ConcurrentMap<String, ClassLoader>>(8, 0.75f, 2);

    private CachingLoadClassClassLoaderFinder() {
    }

    public ClassLoader getLoaderForClass(ClassLoader initiating, String name) {
        ClassLoader loader;
        ConcurrentMap old;
        ConcurrentMap<String, ClassLoader> loadersByClass = (ConcurrentHashMap)this.loaders.get(name);
        if (loadersByClass == null && (old = (ConcurrentMap)this.loaders.putIfAbsent(initiating, loadersByClass = new ConcurrentHashMap(8, 0.75f, 2))) != null) {
            loadersByClass = old;
        }
        if ((loader = (ClassLoader)loadersByClass.get(name)) == null) {
            try {
                Class<?> clazz = SecurityActions.loadClass(initiating, name);
                loader = SecurityActions.getClassLoader(clazz);
                if (loader == null) {
                    loader = SecurityActions.getSystemClassLoader();
                }
                loadersByClass.putIfAbsent(name, loader);
            }
            catch (ClassNotFoundException e) {
                if (name.endsWith(".package-info")) {
                    return null;
                }
                throw new RuntimeException("Could not find '" + name + "' in classloader " + initiating);
            }
        }
        return loader;
    }
}

