/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.jboss.classpool.base.BaseClassPool;
import org.jboss.classpool.base.CtClassCache;
import org.jboss.classpool.base.CtClassCacheFactory;
import org.jboss.classpool.domain.AbstractClassPoolDomain;
import org.jboss.classpool.domain.ClassPoolDomain;
import org.jboss.classpool.helpers.ClassLoaderUtils;
import org.jboss.classpool.scoped.ScopedClassPoolRepository;

public class DelegatingClassPool
extends BaseClassPool {
    private final ClassPoolDomain domain;
    private volatile boolean closed;
    private final CtClassCache cachedLookups;
    private static final CtClassCacheFactory factory = CtClassCacheFactory.createFromProperties();

    public DelegatingClassPool(ClassPoolDomain domain, ClassLoader cl, ClassPool parent, ScopedClassPoolRepository repository) {
        super(cl, parent, repository);
        if (domain == null) {
            throw new IllegalArgumentException("Domain was null");
        }
        if (!(domain instanceof AbstractClassPoolDomain)) {
            throw new IllegalArgumentException("Domain must implement AbstractClassPoolDomain");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " domain:" + (Object)((Object)this)));
        }
        this.domain = domain;
        this.domain.addClassPool(this);
        this.cachedLookups = factory != null ? factory.createCache() : null;
    }

    public CtClass loadLocally(String classname, String resourceName, boolean create) {
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " attempt to load locally " + classname));
        }
        CtClass clazz = null;
        if (this.isLocalResource(resourceName, trace) && (clazz = this.getCachedLocally(classname)) == null && create) {
            clazz = this.createCtClass(classname, true);
        }
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " loaded locally " + classname + " " + this.getClassPoolLogStringForClass(clazz)));
        }
        return clazz;
    }

    public final CtClass get0(String classname, boolean useCache) throws NotFoundException {
        CtClass cachedLookup;
        if (this.cachedLookups != null && (cachedLookup = this.cachedLookups.get(classname, this.domain.getModCount())) != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(classname + " was found in the cache of " + (Object)((Object)this)));
            }
            return cachedLookup;
        }
        if (this.isGeneratedClass(classname)) {
            return null;
        }
        CtClass clazz = this.domain.getCachedOrCreate(this, classname, true);
        if (clazz == null) {
            clazz = this.loadLocally(classname, ClassLoaderUtils.getResourceName(classname), true);
        }
        if (this.cachedLookups != null) {
            this.cachedLookups.put(classname, clazz);
        }
        return clazz;
    }

    public boolean isUnloadedClassLoader() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        super.close();
        this.domain.removeClassPool(this);
    }

    public CtClass getCached(String classname) {
        CtClass clazz = super.getCachedLocally(classname);
        if (clazz != null) {
            return clazz;
        }
        if (this.isGeneratedClass(classname)) {
            return null;
        }
        return this.domain.getCachedOrCreate(this, classname, false);
    }

    public String toString() {
        return "[" + super.toString() + " domain: " + this.domain + "]";
    }
}

