/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.websocket;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class WebSocketFrameEncoder
extends OneToOneEncoder {
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            int type = frame.getType();
            if (frame.isText()) {
                ChannelBuffer data = frame.getBinaryData();
                ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data.order(), data.readableBytes() + 2);
                encoded.writeByte((byte)type);
                encoded.writeBytes(data, data.readableBytes());
                encoded.writeByte(-1);
                return encoded;
            }
            ChannelBuffer data = frame.getBinaryData();
            int dataLen = data.readableBytes();
            ChannelBuffer encoded = channel.getConfig().getBufferFactory().getBuffer(data.order(), dataLen + 5);
            encoded.writeByte((byte)type);
            encoded.writeByte((byte)(dataLen >>> 28 & 0x7F | 0x80));
            encoded.writeByte((byte)(dataLen >>> 14 & 0x7F | 0x80));
            encoded.writeByte((byte)(dataLen >>> 7 & 0x7F | 0x80));
            encoded.writeByte((byte)(dataLen & 0x7F));
            encoded.writeBytes(data, dataLen);
            return encoded;
        }
        return msg;
    }
}

