/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.aop.Dispatcher;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.aspects.security.SecurityClientInterceptor;
import org.jboss.deployers.spi.management.DelegatingComponentDispatcher;
import org.jboss.deployers.spi.management.ManagedComponentRuntimeDispatcher;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedComponent;
import org.jboss.profileservice.management.DelegatingComponentDispatcherImpl;
import org.jboss.profileservice.management.client.ManagedComponentDelegate;
import org.jboss.profileservice.management.client.ManagedOperationDelegate;
import org.jboss.profileservice.management.client.ManagedPropertyDelegate;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.collection.ConcurrentReferenceHashMap;

public class ManagedOperationProxyFactory
extends AbstractManagementProxyFactory
implements DelegatingComponentDispatcherImpl.ProxyRegistry {
    private AtomicLong operationID = new AtomicLong(0L);
    private AtomicLong propertyID = new AtomicLong(0L);
    private ManagedComponentRuntimeDispatcher dispatcher;
    private InvokerLocator locator;
    private Map<Long, ManagedProperty> properties = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private Map<Long, ManagedOperation> operations = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private DelegatingComponentDispatcher dispatcherProxy;
    private String dispatchName;

    public String getDispatchName() {
        return this.dispatchName;
    }

    public void setDispatchName(String dispatchName) {
        this.dispatchName = dispatchName;
    }

    public ManagedComponentRuntimeDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(ManagedComponentRuntimeDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(InvokerLocator locator) {
        this.locator = locator;
    }

    public DelegatingComponentDispatcher getDispatcherProxy() {
        return this.dispatcherProxy;
    }

    public void start() throws Exception {
        if (this.dispatcher == null) {
            throw new IllegalStateException("Null dispatcher.");
        }
        if (this.locator == null) {
            throw new IllegalStateException("Null locator.");
        }
        this.dispatcherProxy = this.createDispatcherProxy();
    }

    public void clear() {
    }

    public ManagedOperation getManagedOperation(Long opID) {
        ManagedOperation op = this.operations.get(opID);
        if (op == null) {
            throw new IllegalStateException("operation not found for id " + opID);
        }
        return op;
    }

    public ManagedProperty getManagedProperty(Long propID) {
        ManagedProperty prop = this.properties.get(propID);
        if (prop == null) {
            throw new IllegalStateException("property not found for id " + propID);
        }
        return prop;
    }

    public ManagedComponent createComponentProxy(ManagedComponent delegate, Object componentName) {
        if (delegate.getComponentName() == null) {
            return delegate;
        }
        if (delegate instanceof ManagedComponentDelegate) {
            return delegate;
        }
        if (!(delegate instanceof MutableManagedComponent)) {
            return delegate;
        }
        return new ManagedComponentDelegate(delegate.getComponentName(), (MutableManagedComponent)MutableManagedComponent.class.cast(delegate), this.dispatcherProxy);
    }

    public ManagedProperty createPropertyProxy(ManagedProperty delegate, Object componentName) {
        if (delegate instanceof ManagedPropertyDelegate) {
            return delegate;
        }
        long propID = this.propertyID.incrementAndGet();
        ManagedPropertyDelegate proxy = new ManagedPropertyDelegate(propID, delegate, componentName, this.dispatcherProxy);
        this.properties.put(propID, proxy);
        return proxy;
    }

    public ManagedOperation createOperationProxy(ManagedOperation delegate, Object componentName) {
        if (delegate instanceof ManagedOperationDelegate) {
            return delegate;
        }
        long opID = this.operationID.incrementAndGet();
        ManagedOperationDelegate proxy = new ManagedOperationDelegate(opID, delegate, componentName, this.dispatcherProxy);
        this.operations.put(opID, proxy);
        return proxy;
    }

    protected DelegatingComponentDispatcher createDispatcherProxy() throws Exception {
        ArrayList<Object> interceptors = new ArrayList<Object>();
        interceptors.add(SecurityClientInterceptor.singleton);
        interceptors.add(MergeMetaDataInterceptor.singleton);
        interceptors.add(InvokeRemoteInterceptor.singleton);
        Class[] ifaces = new Class[]{DelegatingComponentDispatcher.class};
        DelegatingComponentDispatcherImpl delegate = new DelegatingComponentDispatcherImpl(this, this.dispatcher);
        String dispatchName = "ProfileService-" + this.dispatchName;
        Dispatcher.singleton.registerTarget((Object)dispatchName, (Object)delegate);
        return (DelegatingComponentDispatcher)Remoting.createRemoteProxy((Object)dispatchName, (ClassLoader)this.getClass().getClassLoader(), (Class[])ifaces, (InvokerLocator)this.locator, interceptors, (String)"ProfileService");
    }
}

